/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl;

import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.api.Configurable;
import org.jboss.testharness.api.Configuration;
import org.jboss.testharness.api.ConfigurationBuilder;
import org.jboss.testharness.api.TestLauncher;
import org.jboss.testharness.properties.PropertiesManager;
import org.jboss.testharness.spi.Containers;
import org.jboss.testharness.spi.StandaloneContainers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesBasedConfigurationBuilder<T extends Configuration>
implements ConfigurationBuilder {
    private final PropertiesManager propertiesManager = new PropertiesManager();
    private final T configuration;

    public PropertiesBasedConfigurationBuilder(T configuration) {
        this.configuration = configuration;
        configuration.setOutputDirectory(this.propertiesManager.getStringValue("org.jboss.testharness.outputDirectory", Configuration.DEFAULT_OUTPUT_DIRECTORY, false));
        configuration.setStandalone(this.propertiesManager.getBooleanValue("org.jboss.testharness.standalone", true, false));
        configuration.setRunIntegrationTests(this.propertiesManager.getBooleanValue("org.jboss.testharness.runIntegrationTests", false, false));
        configuration.setConnectTimeout(this.propertiesManager.getIntValue("org.jboss.testharness.connectTimeout", 5000, false));
        configuration.setLibraryDirectory(this.propertiesManager.getStringValue("org.jboss.testharness.libraryDirectory", Configuration.DEFAULT_LIBRARY_DIRECTORY, false));
        configuration.setHost(this.propertiesManager.getStringValue("org.jboss.testharness.host", "localhost:8080", false));
        configuration.setTestPackage(this.propertiesManager.getStringValue("org.jboss.testharness.testPackage", null, false));
    }

    public ConfigurationBuilder init() {
        if (!AbstractTest.isInContainer()) {
            this.configuration.setInContainerTestLauncher(this.getInstanceValue(TestLauncher.PROPERTY_NAME, TestLauncher.class, this.configuration.isRunIntegrationTests() || !this.configuration.isStandalone()));
            this.configuration.setContainers(this.getInstanceValue(Containers.PROPERTY_NAME, Containers.class, !this.configuration.isStandalone() || this.configuration.isRunIntegrationTests()));
            this.configuration.setStandaloneContainers(this.getInstanceValue(StandaloneContainers.PROPERTY_NAME, StandaloneContainers.class, this.configuration.isStandalone()));
        }
        return this;
    }

    protected <C> C getInstanceValue(String propertyName, Class<C> expectedType, boolean required) {
        Object instance = this.propertiesManager.getInstanceValue(propertyName, expectedType, required);
        if (instance instanceof Configurable) {
            ((Configurable)instance).setConfiguration(this.configuration);
        }
        return (C)instance;
    }

    public T getConfiguration() {
        return this.configuration;
    }

    protected PropertiesManager getDeploymentProperties() {
        return this.propertiesManager;
    }
}

