/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl.packaging.ear;

import java.net.URL;
import org.jboss.testharness.impl.packaging.ResourceDescriptorImpl;
import org.jboss.testharness.impl.packaging.TCKArtifact;
import org.jboss.testharness.impl.util.Reflections;

public class EjbJarArtifactDescriptor {
    public static final String EJB_JAR_XML_DESTINATION = "META-INF/ejb-jar.xml";
    public static final String STANDARD_EJB_JAR_XML_FILE_NAME = "org/jboss/testharness/impl/packaging/ear/ejb-jar.xml";
    public static final String CUSTOM_EJB_JAR_XML_FILE_NAME = "org/jboss/testharness/impl/packaging/ear/custom-ejb-jar.xml";
    public static final String PERSISTENCE_XML_DESTINATION = "META-INF/persistence.xml";
    public static final String STANDARD_PERSISTENCE_XML_FILE_NAME = "org/jboss/testharness/impl/packaging/ear/persistence.xml";
    public static final String CUSTOM_PERSISTENCE_XML_FILE_NAME = "org/jboss/testharness/impl/packaging/ear/custom-persistence.xml";
    private final String ejbJarXml;
    private final String persistenceXml;
    private final TCKArtifact artifact;

    public static TCKArtifact createEjbJarArtifact(TCKArtifact artifact, String ejbJarXml, String persistenceXml) {
        EjbJarArtifactDescriptor descriptor = new EjbJarArtifactDescriptor(artifact, ejbJarXml, persistenceXml);
        return descriptor.artifact;
    }

    private EjbJarArtifactDescriptor(TCKArtifact artifact, String ejbJarXml, String persistenceXml) {
        this.artifact = artifact;
        this.ejbJarXml = ejbJarXml;
        this.persistenceXml = persistenceXml;
        if (ejbJarXml != null) {
            artifact.getResources().add(new ResourceDescriptorImpl(EJB_JAR_XML_DESTINATION, ejbJarXml));
        } else {
            URL ejbJarXmlLocation = Reflections.loadResource(CUSTOM_EJB_JAR_XML_FILE_NAME);
            if (ejbJarXmlLocation == null) {
                ejbJarXmlLocation = Reflections.loadResource(STANDARD_EJB_JAR_XML_FILE_NAME);
            }
            if (ejbJarXmlLocation != null) {
                artifact.getResources().add(new ResourceDescriptorImpl(EJB_JAR_XML_DESTINATION, ejbJarXmlLocation));
            }
        }
        if (persistenceXml != null) {
            artifact.getResources().add(new ResourceDescriptorImpl(PERSISTENCE_XML_DESTINATION, persistenceXml));
        } else {
            URL persistenceXmlLocation = Reflections.loadResource(CUSTOM_PERSISTENCE_XML_FILE_NAME);
            if (persistenceXmlLocation == null) {
                persistenceXmlLocation = Reflections.loadResource(STANDARD_PERSISTENCE_XML_FILE_NAME);
            }
            if (persistenceXmlLocation != null) {
                artifact.getResources().add(new ResourceDescriptorImpl(PERSISTENCE_XML_DESTINATION, persistenceXmlLocation));
            }
        }
    }

    public String toString() {
        return "EjbJarArtifactDescriptor{ejbJarXml='" + this.ejbJarXml + '\'' + ", persistenceXml='" + this.persistenceXml + '\'' + ", artifact=" + this.artifact + '}';
    }
}

