/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.htmlunit;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.jboss.test.faces.staging.HttpMethod;
import org.jboss.test.faces.staging.StagingConnection;
import org.jboss.test.faces.staging.StagingServer;

public final class LocalWebConnection
implements WebConnection {
    private final StagingServer localServer;

    public LocalWebConnection(StagingServer localServer) {
        this.localServer = localServer;
    }

    public WebResponse getResponse(WebRequest request) throws IOException {
        StagingConnection connection = this.localServer.getConnection(request.getUrl());
        for (NameValuePair param : request.getRequestParameters()) {
            connection.addRequestParameter(param.getName(), param.getValue());
        }
        HttpMethod httpMethod = HttpMethod.valueOf((String)request.getHttpMethod().toString());
        connection.setRequestMethod(httpMethod);
        connection.setRequestCharacterEncoding(request.getCharset());
        String body = request.getRequestBody();
        String contentType = request.getEncodingType().getName();
        connection.setRequestBody(body);
        connection.setRequestContentType(contentType);
        connection.addRequestHeaders(request.getAdditionalHeaders());
        if (null != body && FormEncodingType.URL_ENCODED.getName().equals(contentType)) {
            connection.parseFormParameters(body);
        }
        long startTime = System.currentTimeMillis();
        connection.execute();
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>(10);
        for (Map.Entry entry : connection.getResponseHeaders().entrySet()) {
            for (String value : (String[])entry.getValue()) {
                headers.add(new NameValuePair((String)entry.getKey(), value));
            }
        }
        long contentLength = connection.getResponseContentLength();
        if (contentLength >= 0L) {
            headers.add(new NameValuePair("Content-Length", String.valueOf(contentLength)));
        }
        WebResponseData responseData = new WebResponseData(connection.getResponseBody(), connection.getResponseStatus(), connection.getErrorMessage(), headers);
        return new WebResponse(responseData, request, System.currentTimeMillis() - startTime);
    }
}

