/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.mock;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.easymock.internal.ObjectMethodsFilter;
import org.jboss.test.faces.mock.FacesMockController;
import org.jboss.test.faces.mock.MockFacesEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesMock {
    private static final Class<?> MOCK_OBJECT = FacesMockController.MockObject.class;

    private FacesMock() {
    }

    public static MockFacesEnvironment createMockEnvironment() {
        return new MockFacesEnvironment(EasyMock.createControl());
    }

    public static MockFacesEnvironment createNiceEnvironment() {
        return new MockFacesEnvironment(EasyMock.createNiceControl());
    }

    public static MockFacesEnvironment createStrictEnvironment() {
        return new MockFacesEnvironment(EasyMock.createStrictControl());
    }

    public static <T> T createMock(String name, Class<T> clazz, IMocksControl control) {
        if (MOCK_OBJECT.isAssignableFrom(clazz)) {
            try {
                Constructor<T> constructor = clazz.getConstructor(IMocksControl.class, String.class);
                return constructor.newInstance(control, name);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Class " + clazz.getName() + " cannot be created", e);
            }
        }
        try {
            return FacesMockController.createMock(name, clazz, control);
        }
        catch (ClassNotFoundException e) {
            return (T)control.createMock(name, clazz);
        }
    }

    public static <T> T createMock(Class<T> clazz) {
        return FacesMock.createMock(null, clazz);
    }

    public static <T> T createMock(String name, Class<T> clazz) {
        return FacesMock.createMock(name, clazz, EasyMock.createControl());
    }

    public static <T> T createNiceMock(Class<T> clazz) {
        return FacesMock.createNiceMock(null, clazz);
    }

    public static <T> T createNiceMock(String name, Class<T> clazz) {
        return FacesMock.createMock(name, clazz, EasyMock.createNiceControl());
    }

    public static <T> T createStrictMock(Class<T> clazz) {
        return FacesMock.createStrictMock(null, clazz);
    }

    public static <T> T createStrictMock(String name, Class<T> clazz) {
        return FacesMock.createMock(name, clazz, EasyMock.createStrictControl());
    }

    private static IMocksControl getControl(Object mock) {
        Class<?>[] interfaces;
        if (mock instanceof FacesMockController.MockObject) {
            FacesMockController.MockObject mockObject = (FacesMockController.MockObject)mock;
            return mockObject.getControl();
        }
        for (Class<?> interfaze : interfaces = mock.getClass().getInterfaces()) {
            if (!"MockObject".equals(interfaze.getSimpleName()) || null == interfaze.getEnclosingClass()) continue;
            try {
                Method getControl = interfaze.getMethod("getControl", new Class[0]);
                if (!IMocksControl.class.equals(getControl.getReturnType())) continue;
                return (IMocksControl)getControl.invoke(mock, new Object[0]);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        return ((ObjectMethodsFilter)Proxy.getInvocationHandler(mock)).getDelegate().getControl();
    }

    public static void replay(Object ... mocks) {
        for (Object mock : mocks) {
            FacesMock.getControl(mock).replay();
        }
    }

    public static void reset(Object ... mocks) {
        for (Object mock : mocks) {
            FacesMock.getControl(mock).reset();
        }
    }

    public static void resetToNice(Object ... mocks) {
        for (Object mock : mocks) {
            FacesMock.getControl(mock).resetToNice();
        }
    }

    public static void resetToDefault(Object ... mocks) {
        for (Object mock : mocks) {
            FacesMock.getControl(mock).resetToDefault();
        }
    }

    public static void resetToStrict(Object ... mocks) {
        for (Object mock : mocks) {
            FacesMock.getControl(mock).resetToStrict();
        }
    }

    public static void verify(Object ... mocks) {
        for (Object object : mocks) {
            FacesMock.getControl(object).verify();
        }
    }

    public static void checkOrder(Object mock, boolean state) {
        FacesMock.getControl(mock).checkOrder(state);
    }
}

