/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.mock;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.test.faces.mock.Environment;
import org.jboss.test.faces.mock.FacesMock;
import org.jboss.test.faces.mock.Mock;
import org.jboss.test.faces.mock.MockController;
import org.jboss.test.faces.mock.MockFacesEnvironment;
import org.jboss.test.faces.mock.Strict;
import org.jboss.test.faces.mock.Stub;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockTestRunner
extends BlockJUnit4ClassRunner {
    public MockTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Set<Field> getFields(Class<?> c) {
        HashSet<Field> fields = new HashSet<Field>(Arrays.asList(c.getDeclaredFields()));
        while ((c = c.getSuperclass()) != null) {
            for (Field f : c.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || Modifier.isPrivate(f.getModifiers())) continue;
                fields.add(f);
            }
        }
        return fields;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        super.runChild(method, notifier);
    }

    protected Object createTest() throws Exception {
        Class c = this.getTestClass().getJavaClass();
        Set<Field> testFields = this.getFields(c);
        Map<Field, Binding> fieldValues = this.getMockValues(testFields);
        Object test = super.createTest();
        for (Field field : fieldValues.keySet()) {
            Binding binding = fieldValues.get(field);
            field.setAccessible(true);
            if (null == binding.getValue() || field.get(test) != null) continue;
            field.set(test, binding.getValue());
        }
        return test;
    }

    private Map<Field, Binding> getMockValues(Set<Field> testFields) {
        HashMap<Field, Binding> mocksAndStubs = new HashMap<Field, Binding>();
        for (Field field : testFields) {
            if (field.isAnnotationPresent(Strict.class)) {
                mocksAndStubs.put(field, this.createMockBinding(field, FacesMock.createStrictMock(this.notEmpty(field.getAnnotation(Strict.class).value()), field.getType())));
            }
            if (field.isAnnotationPresent(Mock.class)) {
                mocksAndStubs.put(field, this.createMockBinding(field, FacesMock.createMock(this.notEmpty(field.getAnnotation(Mock.class).value()), field.getType())));
                continue;
            }
            if (field.isAnnotationPresent(Stub.class)) {
                mocksAndStubs.put(field, this.createMockBinding(field, FacesMock.createNiceMock(this.notEmpty(field.getAnnotation(Stub.class).value()), field.getType())));
                continue;
            }
            if (!field.getType().isAssignableFrom(MockController.class)) continue;
            FieldModule module = new FieldModule(mocksAndStubs);
            mocksAndStubs.put(field, this.createBinding(field, module));
        }
        return mocksAndStubs;
    }

    private Binding createMockBinding(Field field, Object value) {
        Binding bind = this.createBinding(field, value);
        bind.setMock(true);
        if (field.isAnnotationPresent(Environment.class)) {
            MockFacesEnvironment environment = (MockFacesEnvironment)value;
            block8: for (Environment.Feature feature : field.getAnnotation(Environment.class).value()) {
                switch (feature) {
                    case EXTERNAL_CONTEXT: {
                        environment.withExternalContext();
                        continue block8;
                    }
                    case APPLICATION: {
                        environment.withApplication();
                        continue block8;
                    }
                    case FACTORIES: {
                        environment.withFactories();
                        continue block8;
                    }
                    case RENDER_KIT: {
                        environment.withRenderKit();
                        continue block8;
                    }
                    case SERVLET_REQUEST: {
                        environment.withServletRequest();
                        continue block8;
                    }
                    case RESPONSE_WRITER: {
                        environment.withReSponseWriter();
                    }
                }
            }
        }
        return bind;
    }

    private Binding createBinding(Field field, Object value) {
        Binding bind = new Binding();
        bind.setValue(value);
        return bind;
    }

    private String notEmpty(String value) {
        return "".equals(value) ? null : value;
    }

    protected static final class Binding {
        private Object value;
        private boolean mock;

        protected Binding() {
        }

        void setValue(Object value) {
            this.value = value;
        }

        Object getValue() {
            return this.value;
        }

        public void setMock(boolean mock) {
            this.mock = mock;
        }

        public boolean isMock() {
            return this.mock;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class FieldModule
    implements MockController {
        final Map<Field, Binding> fields;

        public FieldModule(Map<Field, Binding> fields) {
            this.fields = fields;
        }

        private void perform(Invoker invoker, Object ... objects) {
            for (Binding field : this.fields.values()) {
                if (!field.isMock()) continue;
                if (field.getValue() instanceof MockFacesEnvironment) {
                    invoker.perform((MockFacesEnvironment)field.getValue());
                    continue;
                }
                invoker.perform(field.getValue());
            }
            invoker.perform(objects);
        }

        @Override
        public void reset(Object ... objects) {
            this.perform(new Invoker(){

                public void perform(MockFacesEnvironment environment) {
                    environment.reset();
                }

                public void perform(Object ... objects) {
                    FacesMock.reset(objects);
                }
            }, objects);
        }

        @Override
        public void resetToNice(Object ... objects) {
            this.perform(new Invoker(){

                public void perform(MockFacesEnvironment environment) {
                    environment.resetToNice();
                }

                public void perform(Object ... objects) {
                    FacesMock.resetToNice(objects);
                }
            }, objects);
        }

        @Override
        public void resetToStrict(Object ... objects) {
            this.perform(new Invoker(){

                public void perform(MockFacesEnvironment environment) {
                    environment.resetToStrict();
                }

                public void perform(Object ... objects) {
                    FacesMock.resetToStrict(objects);
                }
            }, objects);
        }

        @Override
        public void resetToDefault(Object ... objects) {
            this.perform(new Invoker(){

                public void perform(MockFacesEnvironment environment) {
                    environment.resetToDefault();
                }

                public void perform(Object ... objects) {
                    FacesMock.resetToDefault(objects);
                }
            }, objects);
        }

        @Override
        public void verify(Object ... objects) {
            this.perform(new Invoker(){

                public void perform(MockFacesEnvironment environment) {
                    environment.verify();
                }

                public void perform(Object ... objects) {
                    FacesMock.verify(objects);
                }
            }, objects);
        }

        @Override
        public void replay(Object ... objects) {
            this.perform(new Invoker(){

                public void perform(MockFacesEnvironment environment) {
                    environment.replay();
                }

                public void perform(Object ... objects) {
                    FacesMock.replay(objects);
                }
            }, objects);
        }

        @Override
        public void release() {
            this.perform(new Invoker(){

                public void perform(MockFacesEnvironment environment) {
                    environment.release();
                }

                public void perform(Object ... objects) {
                }
            }, new Object[0]);
        }

        static interface Invoker {
            public void perform(Object ... var1);

            public void perform(MockFacesEnvironment var1);
        }
    }
}

