/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.mock.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.jboss.test.faces.mock.FacesMock;
import org.jboss.test.faces.mock.component.Facet;
import org.jboss.test.faces.mock.component.TreeBuilder;
import org.jboss.test.faces.mock.component.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeBuilderImpl<C extends UIComponent>
implements TreeBuilder<C> {
    private final C component;
    private final List<TreeBuilder<?>> childrenBuilders;
    private final List<UIComponent> children;
    private final Map<String, UIComponent> facets;

    protected TreeBuilderImpl(C component) {
        this.component = component;
        this.childrenBuilders = new ArrayList();
        this.children = new ArrayList<UIComponent>();
        this.facets = new HashMap<String, UIComponent>();
        EasyMock.expect((Object)component.getChildren()).andStubReturn(this.children);
        EasyMock.expect((Object)component.getFacets()).andStubReturn(this.facets);
        EasyMock.expect((Object)component.getChildCount()).andStubAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return TreeBuilderImpl.this.children.size();
            }
        });
        final Capture facetNameCapture = new Capture();
        EasyMock.expect((Object)component.getFacet((String)EasyMock.capture((Capture)facetNameCapture))).andStubAnswer((IAnswer)new IAnswer<UIComponent>(){

            public UIComponent answer() throws Throwable {
                return (UIComponent)TreeBuilderImpl.this.facets.get(facetNameCapture.getValue());
            }
        });
        EasyMock.expect((Object)component.getFacetCount()).andStubAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return TreeBuilderImpl.this.facets.size();
            }
        });
        EasyMock.expect((Object)component.getFacetsAndChildren()).andStubAnswer((IAnswer)new IAnswer<Iterator<UIComponent>>(){

            public Iterator<UIComponent> answer() throws Throwable {
                ArrayList facetsAndChildren = new ArrayList(TreeBuilderImpl.this.facets.values());
                facetsAndChildren.addAll(TreeBuilderImpl.this.children);
                return facetsAndChildren.iterator();
            }
        });
    }

    @Override
    public TreeBuilder<C> id(String id) {
        EasyMock.expect((Object)this.component.getId()).andStubReturn((Object)id);
        return this;
    }

    @Override
    public void replay() {
        this.visitTree(new TreeVisitor(){

            @Override
            public void visit(TreeBuilder<?> toVisit) {
                FacesMock.replay(toVisit.getComponent());
            }
        });
    }

    @Override
    public void verify() {
        this.visitTree(new TreeVisitor(){

            @Override
            public void visit(TreeBuilder<?> toVisit) {
                FacesMock.verify(toVisit.getComponent());
            }
        });
    }

    @Override
    public void visitTree(TreeVisitor visitor) {
        visitor.visit(this);
        for (TreeBuilder<?> child : this.childrenBuilders) {
            child.visitTree(visitor);
        }
    }

    @Override
    public C getComponent() {
        return this.component;
    }

    @Override
    public TreeBuilder<C> children(TreeBuilder<?> ... builders) {
        for (TreeBuilder<?> treeBuilder : builders) {
            this.children.add((UIComponent)treeBuilder.getComponent());
            this.addChildBuilder(treeBuilder);
        }
        return this;
    }

    private void addChildBuilder(TreeBuilder<?> treeBuilder) {
        this.childrenBuilders.add(treeBuilder);
        EasyMock.expect((Object)treeBuilder.getComponent().getParent()).andStubReturn(this.component);
    }

    @Override
    public TreeBuilder<C> facets(Facet<?> ... facets) {
        for (Facet<?> facet : facets) {
            this.facets.put(facet.getName(), (UIComponent)facet.getBuilder().getComponent());
            this.addChildBuilder(facet.getBuilder());
        }
        return null;
    }
}

