/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.stub.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.jboss.test.faces.stub.util.IteratorEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StubServletContext
implements ServletContext {
    private Map<String, String> initParameters = new HashMap<String, String>();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private File webappRoot;
    private File webInfRoot;
    private File webInfClassesRoot;

    public StubServletContext() {
        try {
            URL webxml = this.getClass().getResource("/WEB-INF/web.xml");
            if (webxml != null) {
                this.webInfRoot = new File(webxml.toURI()).getParentFile();
                if (this.webInfRoot != null) {
                    this.webInfClassesRoot = new File(this.webInfRoot.getParentFile().getPath() + "/classes");
                    this.webappRoot = this.webInfRoot.getParentFile();
                }
                this.processContextParameters(webxml);
            } else {
                this.webappRoot = new File(this.getClass().getResource("/.").toURI());
            }
        }
        catch (URISyntaxException e) {
            System.out.println("Unable to find web.xml:" + e.getMessage());
        }
    }

    private void processContextParameters(URL webXML) {
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public ServletContext getContext(String name) {
        return this;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public String getMimeType(String arg0) {
        return null;
    }

    public Set getResourcePaths(String name) {
        Enumeration<URL> enumeration = null;
        try {
            enumeration = this.getClass().getClassLoader().getResources("WEB-INF");
        }
        catch (IOException e) {
            throw new RuntimeException("Error finding webroot.", e);
        }
        HashSet<String> result = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            File rootFile = new File(url.getPath()).getParentFile();
            File newFile = new File(rootFile.getPath() + name);
            File[] files = newFile.listFiles();
            if (files == null) continue;
            StubServletContext.addPaths(result, files, rootFile.getPath());
        }
        return result;
    }

    private static void addPaths(Set<String> result, File[] files, String rootPath) {
        for (File file : files) {
            String filePath = file.getPath().substring(rootPath.length()).replace('\\', '/');
            if (file.isDirectory()) {
                result.add(filePath + "/");
                continue;
            }
            result.add(filePath);
        }
    }

    public URL getResource(String name) throws MalformedURLException {
        File file = StubServletContext.getFile(name, this.webappRoot);
        if (file == null) {
            file = StubServletContext.getFile(name, this.webInfRoot);
        }
        if (file == null) {
            file = StubServletContext.getFile(name, this.webInfClassesRoot);
        }
        if (file != null) {
            return file.toURI().toURL();
        }
        return null;
    }

    private static File getFile(String name, File root) {
        File f;
        if (root == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (!(f = new File(root, name)).exists()) {
            return null;
        }
        return f;
    }

    public InputStream getResourceAsStream(String name) {
        return this.getClass().getResourceAsStream(name);
    }

    public RequestDispatcher getRequestDispatcher(String url) {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        throw new UnsupportedOperationException();
    }

    public Servlet getServlet(String name) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public Enumeration getServlets() {
        return null;
    }

    public Enumeration getServletNames() {
        return null;
    }

    public void log(String msg) {
    }

    public void log(Exception ex, String msg) {
    }

    public void log(String msg, Throwable ex) {
    }

    public String getRealPath(String relativePath) {
        if (this.webappRoot != null) {
            return this.webappRoot.getAbsolutePath() + relativePath;
        }
        return relativePath;
    }

    public String getServerInfo() {
        return null;
    }

    public String getInitParameter(String param) {
        return this.initParameters.get(param);
    }

    public Enumeration getInitParameterNames() {
        return new IteratorEnumeration(this.initParameters.keySet().iterator());
    }

    public Object getAttribute(String att) {
        return this.attributes.get(att);
    }

    public Enumeration getAttributeNames() {
        return new IteratorEnumeration(this.attributes.keySet().iterator());
    }

    public void setAttribute(String att, Object value) {
        if (value == null) {
            this.attributes.remove(value);
        } else {
            this.attributes.put(att, value);
        }
    }

    public void removeAttribute(String att) {
        this.attributes.remove(att);
    }

    public String getServletContextName() {
        return "Mock";
    }

    public String getContextPath() {
        return null;
    }
}

