/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.mock.factory;

import java.lang.reflect.Field;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Factory;
import org.easymock.classextension.EasyMock;
import org.easymock.classextension.internal.ClassExtensionHelper;
import org.easymock.classextension.internal.ClassProxyFactory;
import org.jboss.test.faces.mock.factory.FactoryMock;
import org.jboss.test.faces.mock.factory.SerializableNoOp;

public class FactoryMockImpl<T>
implements FactoryMock<T> {
    private static final String MOCKITO_COMPATIBILITY_MESSAGE = "Mockito internals has changed and this code not anymore compatible";
    private Class<T> originalClass;
    private T mock;

    FactoryMockImpl(Class<T> type) {
        this.originalClass = type;
        this.initialize();
    }

    private void initialize() {
        this.mock = EasyMock.createMock(this.originalClass);
    }

    @Override
    public Class<T> getMockClass() {
        return this.mock.getClass();
    }

    @Override
    public String getMockClassName() {
        return this.mock.getClass().getName();
    }

    @Override
    public T createNewMockInstance() {
        try {
            return (T)this.mock.getClass().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot create instance for mock factory of class '" + this.originalClass + "'", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Cannot create instance for mock factory of class '" + this.originalClass + "'", e);
        }
    }

    void enhance(T mockToEnhance) {
        ClassProxyFactory.MockMethodInterceptor interceptor = ClassExtensionHelper.getInterceptor(this.mock);
        ((Factory)mockToEnhance).setCallbacks(new Callback[]{interceptor, SerializableNoOp.SERIALIZABLE_INSTANCE});
    }

    private Field getDeclaredFieldFromType(Class<?> type, String fieldName) {
        try {
            return type.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            throw new IllegalStateException(MOCKITO_COMPATIBILITY_MESSAGE, e);
        }
    }

    private Object getObjectFromDeclaredField(Object instance, Field field) {
        boolean accessible = field.isAccessible();
        Object result = null;
        if (!accessible) {
            field.setAccessible(true);
        }
        try {
            result = field.get(instance);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (!accessible) {
                field.setAccessible(false);
            }
        }
        return result;
    }
}

