/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.mockito.factory;

import java.lang.reflect.Field;
import org.jboss.test.faces.mockito.factory.FactoryMock;
import org.mockito.Mockito;
import org.mockito.cglib.proxy.Callback;
import org.mockito.cglib.proxy.Factory;
import org.mockito.internal.MockitoCore;
import org.mockito.internal.MockitoInvocationHandler;
import org.mockito.internal.creation.MethodInterceptorFilter;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.creation.jmock.SerializableNoOp;
import org.mockito.internal.util.MockUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryMockImpl<T>
implements FactoryMock<T> {
    private static final String MOCKITO_COMPATIBILITY_MESSAGE = "Mockito internals has changed and this code not anymore compatible";
    private Class<T> originalClass;
    private T mock;

    FactoryMockImpl(Class<T> type) {
        this.originalClass = type;
        this.initialize();
    }

    private void initialize() {
        this.mock = Mockito.mock(this.originalClass);
    }

    @Override
    public Class<T> getMockClass() {
        return this.mock.getClass();
    }

    @Override
    public String getMockClassName() {
        return this.mock.getClass().getName();
    }

    @Override
    public T createNewMockInstance() {
        try {
            return (T)this.mock.getClass().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot create instance for mock factory of class '" + this.originalClass + "'", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Cannot create instance for mock factory of class '" + this.originalClass + "'", e);
        }
    }

    void enhance(T mockToEnhance) {
        MockUtil mockUtil = this.getMockUtil();
        MockitoInvocationHandler mockHandler = (MockitoInvocationHandler)mockUtil.getMockHandler(this.mock);
        MethodInterceptorFilter filter = new MethodInterceptorFilter(mockHandler, this.getDefaultSettings());
        ((Factory)mockToEnhance).setCallbacks(new Callback[]{filter, SerializableNoOp.SERIALIZABLE_INSTANCE});
    }

    private MockSettingsImpl getDefaultSettings() {
        return (MockSettingsImpl)new MockSettingsImpl().defaultAnswer(Mockito.RETURNS_DEFAULTS);
    }

    private MockUtil getMockUtil() {
        MockitoCore mockitoCore = this.getMockitoCore();
        Field field = this.getDeclaredFieldFromType(MockitoCore.class, "mockUtil");
        return (MockUtil)this.getObjectFromDeclaredField(mockitoCore, field);
    }

    private MockitoCore getMockitoCore() {
        Field mockitoCoreField = this.getDeclaredFieldFromType(Mockito.class, "MOCKITO_CORE");
        return (MockitoCore)this.getObjectFromDeclaredField(null, mockitoCoreField);
    }

    private Field getDeclaredFieldFromType(Class<?> type, String fieldName) {
        try {
            return type.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            throw new IllegalStateException(MOCKITO_COMPATIBILITY_MESSAGE, e);
        }
    }

    private Object getObjectFromDeclaredField(Object instance, Field field) {
        boolean accessible = field.isAccessible();
        Object result = null;
        if (!accessible) {
            field.setAccessible(true);
        }
        try {
            result = field.get(instance);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (!accessible) {
                field.setAccessible(false);
            }
        }
        return result;
    }
}

