/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.jetty;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.mortbay.resource.Resource;

public class StringContentResource
extends Resource {
    private static final long serialVersionUID = -545867200766773535L;
    private byte[] content;
    private String path;

    public StringContentResource(String contentString, String path) {
        this.content = contentString.getBytes();
        this.path = path;
    }

    public Resource addPath(String path) throws IOException, MalformedURLException {
        throw new FileNotFoundException(path);
    }

    public boolean delete() throws SecurityException {
        return false;
    }

    public boolean exists() {
        return true;
    }

    public File getFile() throws IOException {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public String getName() {
        return this.path;
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        throw new FileNotFoundException(this.path);
    }

    public URL getURL() {
        try {
            return new URL("urn", null, 0, "", new URLStreamHandler(){

                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        public void connect() throws IOException {
                        }

                        public Object getContent() throws IOException {
                            return StringContentResource.this.content;
                        }

                        public InputStream getInputStream() throws IOException {
                            return StringContentResource.this.getInputStream();
                        }
                    };
                }
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isDirectory() {
        return false;
    }

    public long lastModified() {
        return -1L;
    }

    public long length() {
        return this.content.length;
    }

    public String[] list() {
        return null;
    }

    public void release() {
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        return false;
    }
}

