/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.qunit;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.jboss.test.qunit.ScriptRef;
import org.jboss.test.qunit.URLRefBase;

public class ResourceRef
extends URLRefBase
implements ScriptRef {
    private final String src;

    public ResourceRef(String src) {
        this.src = src;
    }

    public URL getScript(Object base) {
        URL resource = base.getClass().getResource(this.src);
        if (null == resource) {
            throw new RuntimeException("Resource not found: " + this.src);
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("http://localhost");
            if (!this.src.startsWith("/")) {
                stringBuilder.append('/');
            }
            stringBuilder.append(this.src);
            URL url = new URL(stringBuilder.toString());
            return url;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid resource url: ", e);
        }
    }

    public String getContent(Object base) {
        try {
            URL resource = base.getClass().getResource(this.src);
            if (null == resource) {
                throw new RuntimeException("Resource not found: " + this.src);
            }
            URLConnection connection = resource.openConnection();
            connection.setUseCaches(false);
            InputStream inputStream = connection.getInputStream();
            return this.readInputStream(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

