/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.qunit;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.MockWebConnection;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.test.qunit.ContentRef;
import org.jboss.test.qunit.ExternalRef;
import org.jboss.test.qunit.ResourceRef;
import org.jboss.test.qunit.ScriptRef;
import org.jboss.test.qunit.URLRef;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class Qunit
implements MethodRule {
    private ScriptRef htmlContent = new ContentRef("");
    private BrowserVersion browser = BrowserVersion.getDefault();
    private List<ScriptRef> scripts = new ArrayList<ScriptRef>();
    private WebClient webClient;
    private HtmlPage page;
    private MockWebConnection mockConnection;
    public static final String DEFAULT_URL = "http://localhost";

    protected Qunit() {
    }

    public Statement apply(final Statement base, final FrameworkMethod method, final Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    System.out.println("Run Statement " + base.getClass().getName() + " for method " + method.getName());
                    Qunit.this.setupQunit(method, target);
                    base.evaluate();
                }
                finally {
                    Qunit.this.thearDownQunit(method, target);
                }
            }
        };
    }

    protected void thearDownQunit(FrameworkMethod method, Object target) {
        if (null != this.page) {
            this.webClient.closeAllWindows();
        }
    }

    protected void setupQunit(FrameworkMethod method, Object target) throws FailingHttpStatusCodeException, IOException {
        URL URL2 = new URL("http://localhost/");
        this.setupWebClient();
        String content = this.buildContent(method, target);
        this.mockConnection.setResponse(URL2, content);
        this.page = (HtmlPage)this.webClient.getPage(URL2);
        this.webClient.waitForBackgroundJavaScriptStartingBefore(240000L);
    }

    private void setupWebClient() {
        this.webClient = new WebClient(this.browser);
        this.mockConnection = new MockWebConnection();
        this.webClient.setWebConnection((WebConnection)this.mockConnection);
        this.webClient.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
    }

    private String buildContent(FrameworkMethod method, Object target) {
        StringBuilder content = new StringBuilder();
        content.append("<html><head><title>").append(method.getName()).append("</title>");
        this.appendScripts(content, target);
        content.append("</head><body>").append(this.getHtmlContent(target)).append("</body></html>");
        return content.toString();
    }

    private void appendScripts(StringBuilder content, Object target) {
        for (ScriptRef script : this.scripts) {
            content.append("<script type=\"text/javascript\" src=\"");
            URL url = script.getScript(target);
            content.append(url.toExternalForm());
            content.append("\" ></script>\n");
            this.mockConnection.setResponse(url, script.getContent(target), "application/javascript");
        }
    }

    private URL calculateDefaultURL(Object target) {
        Class<?> targetClass = target.getClass();
        String resourceName = targetClass.getSimpleName() + ".class";
        return targetClass.getResource(resourceName);
    }

    protected String getHtmlContent(Object target) {
        return this.htmlContent.getContent(target);
    }

    private void setHtmlContent(ScriptRef htmlContent) {
        this.htmlContent = htmlContent;
    }

    private void addScript(ScriptRef src) {
        this.scripts.add(src);
    }

    public Object runScript(String script) {
        ScriptResult scriptResult = this.page.executeJavaScript(script);
        this.page = (HtmlPage)scriptResult.getNewPage();
        return scriptResult.getJavaScriptResult();
    }

    public HtmlPage getPage() {
        return this.page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Qunit rule = new Qunit();

        public Builder content(String content) {
            this.rule.setHtmlContent(new ContentRef(content));
            return this;
        }

        public Builder contentResource(String src) {
            this.rule.setHtmlContent(new ResourceRef(src));
            return this;
        }

        public Builder load(URL src) {
            this.rule.addScript(new URLRef(src));
            return this;
        }

        public Builder loadResource(String src) {
            this.rule.addScript(new ResourceRef(src));
            return this;
        }

        public Builder loadJsfResource(String name) {
            this.rule.addScript(new ResourceRef("/META-INF/resources/" + name));
            return this;
        }

        public Builder loadJsfResource(String name, String library) {
            this.rule.addScript(new ResourceRef("/META-INF/resources/" + library + "/" + name));
            return this;
        }

        public Builder loadExternal(String src) {
            this.rule.addScript(new ExternalRef(src));
            return this;
        }

        public Builder loadContent(String foo) {
            this.rule.addScript(new ContentRef(foo));
            return this;
        }

        public Builder emulate(BrowserVersion browser) {
            this.rule.browser = browser;
            return this;
        }

        public Qunit build() {
            return this.rule;
        }
    }
}

