/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mockgenerator;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Formattable;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import org.jboss.mockgenerator.JavaSource;

public class MockJavaSource
extends JavaSource {
    private final String className;
    private static final String fileHeader = "/*\n * GENERATED FILE - DO NOT EDIT\n */\n\npackage %1$s;\n\nimport static org.easymock.EasyMock.*;\nimport static %4$s.findMethod;\nimport static %4$s.invokeMethod;\n\nimport java.lang.reflect.Method;\nimport org.easymock.IMocksControl;\nimport %4$s;\nimport %4$s.MockObject;\n\npublic class %2$s extends %3$s implements MockObject {\n\n    private final IMocksControl control;\n\n    private final String name;\n\n    /**\n     * Default constructor\n     */\n    public %2$s() {\n            %5$s            this.control =  createControl();\n            this.name = null;\n    }\n\n    /**\n     * @param control\n     */\n    public %2$s(IMocksControl control, String name) {\n        %5$s        this.control = control;\n        this.name = name;\n    }\n\n    public IMocksControl getControl() {\n        return control;\n    }\n";
    private static final String fileFooter = "\n\n    public String toString() {\n        return getClass().getSimpleName() + (name != null ? name : \"\");\n    }\n\n    public boolean equals(Object obj) {\n        return this == obj;\n    }\n\n    public int hashCode() {\n        if (name != null) {\n           final int prime = 31;\n           int result = 1;\n           result = prime * result + name.hashCode();\n           result = prime * result + getClass().getName().hashCode();\n           return result;\n        } else {           return System.identityHashCode(this);\n        }\n    }\n\n}\n";
    private final String mockController;
    private static final String methodConstant = "    private static final Method %2$sMethod%4$d = findMethod(%1$s.class, \"%2$s\"%3$s);\n";
    private static final String voidMethod = "//    @Override\n    public void %2$s(%3$s) {\n            invokeMethod(this.control,this, %2$sMethod%5$d %4$s);\n    }\n";
    private static final String valueMethod = "//    @Override\n    public %1$s %2$s(%3$s) {\n            return (%6$s)invokeMethod(this.control,this, %2$sMethod%5$d %4$s);\n    }\n";
    private Map<String, Integer> methods = new HashMap<String, Integer>();

    public MockJavaSource(File directory, String mockClassName, String className, String mockController) {
        super(directory, mockClassName);
        this.className = className;
        this.mockController = mockController;
    }

    public void printFileHeader(String postConstruct) {
        this.sprintf(fileHeader, this.mockPackage, this.mockClass, this.className, this.mockController, this.notNullString(postConstruct));
    }

    private String notNullString(String postConstruct) {
        return null == postConstruct ? "" : postConstruct;
    }

    public void printMethod(Method method) {
        String name = method.getName();
        Integer methodNumber = this.methods.get(name);
        methodNumber = null == methodNumber ? new Integer(0) : Integer.valueOf(methodNumber + 1);
        this.methods.put(name, methodNumber);
        Class[] parameterTypes = method.getParameterTypes();
        ParametersFormatter parameterTypesFormat = new ParametersFormatter(parameterTypes);
        parameterTypesFormat.setFormat(",%1$s.class");
        this.sprintf(methodConstant, this.className, name, parameterTypesFormat, methodNumber);
        parameterTypesFormat.setFormat("%3$s%1$s arg%2$d");
        parameterTypesFormat.setVarargs(method.isVarArgs());
        ParametersFormatter argumentsFormat = new ParametersFormatter(parameterTypes);
        argumentsFormat.setFormat(",arg%2$d");
        Class<?> returnType = method.getReturnType();
        if (Void.TYPE.equals(returnType)) {
            this.sprintf(voidMethod, "void", name, parameterTypesFormat, argumentsFormat, methodNumber);
        } else {
            this.sprintf(valueMethod, MockJavaSource.classToString(returnType, false), name, parameterTypesFormat, argumentsFormat, methodNumber, MockJavaSource.boxingClassName(returnType));
        }
    }

    public void printFileFooter(String codeSegment) {
        if (null != codeSegment) {
            this.write(codeSegment);
        }
        this.write(fileFooter);
    }

    private final class ParametersFormatter
    implements Formattable {
        private final Class<?>[] parameterTypes;
        private String format = ",%1$s.class";
        private boolean varargs = false;

        public void setVarargs(boolean varargs) {
            this.varargs = varargs;
        }

        private ParametersFormatter(Class<?>[] parameterTypes) {
            this.parameterTypes = parameterTypes;
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                Class<?> parameter = this.parameterTypes[i];
                formatter.format(this.getFormat(), JavaSource.classToString(parameter, this.varargs && i == this.parameterTypes.length - 1), i, 0 == i ? "" : ",");
            }
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

