/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.clusterbench.common.debug;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.test.clusterbench.common.SerialBean;

public abstract class AbstractCommonDebugServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(AbstractCommonDebugServlet.class.getName());
    public static final String KEY = AbstractCommonDebugServlet.class.getName();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession session = req.getSession(true);
        PrintWriter out = resp.getWriter();
        if (session.isNew()) {
            log.log(Level.INFO, "New session created: {0}", session.getId());
            session.setAttribute(KEY, (Object)new SerialBean());
        } else if (session.getAttribute(KEY) == null) {
            log.log(Level.INFO, "Session is not new, creating SerialBean: {0}", session.getId());
            session.setAttribute(KEY, (Object)new SerialBean());
        }
        SerialBean bean = (SerialBean)session.getAttribute(KEY);
        resp.setContentType("text/plain");
        if (req.getParameter("readonly") != null) {
            out.print(bean.getSerial());
            out.println(this.getContainerSpecificDebugInfo(req));
            return;
        }
        int serial = bean.getSerial();
        bean.setSerial(serial + 1);
        session.setAttribute(KEY, (Object)bean);
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            out.println("Request header: " + header + "=" + req.getHeader(header));
        }
        out.println("Serial: " + serial);
        out.println("Session ID: " + req.getSession().getId());
        out.println("Current time: " + new Date());
        out.println("ServletRequest.getServerPort(): " + req.getServerPort());
        out.println("ServletRequest.getLocalPort(): " + req.getLocalPort());
        out.println("Node name: " + System.getProperty("jboss.node.name"));
        out.println(this.getContainerSpecificDebugInfo(req));
        if (req.getParameter("invalidate") != null) {
            log.log(Level.INFO, "Invalidating: {0}", session.getId());
            session.invalidate();
        }
    }

    public String getServletInfo() {
        return "Debug servlet.";
    }

    public abstract String getContainerSpecificDebugInfo(HttpServletRequest var1);
}

