/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.clusterbench.common.load;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AverageSystemLoad {
    private static final Logger log = Logger.getLogger(AverageSystemLoad.class.getName());
    private List<LoadRunner> loadRunners = new ArrayList<LoadRunner>();

    public String spawnLoadThreads(int numberOfThreads, int milliseconds) {
        long operationStarted = System.currentTimeMillis();
        for (int i = 0; i < numberOfThreads; ++i) {
            this.loadRunners.add(new LoadRunner(milliseconds));
        }
        while (this.stillActiveRunners() != 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                log.log(Level.SEVERE, "Whoops, our monitoring thread has been interrupted.");
            }
        }
        return "DONE, I was stressing CPU with " + numberOfThreads + " evil threads for " + (System.currentTimeMillis() - operationStarted) + " milliseconds (including warm-up).";
    }

    private int stillActiveRunners() {
        int stillActiveRunners = 0;
        for (LoadRunner loadRunner : this.loadRunners) {
            if (loadRunner.isComplete()) continue;
            ++stillActiveRunners;
        }
        return stillActiveRunners;
    }

    private class LoadRunner
    implements Runnable {
        private int milliseconds;
        private boolean isComplete = false;
        private Thread runner;

        public LoadRunner(int milliseconds) {
            this.milliseconds = milliseconds;
            this.runner = new Thread(this);
            this.runner.start();
        }

        @Override
        public void run() {
            long howLong = (long)this.milliseconds * 1000000L;
            long startTime = System.nanoTime();
            while (System.nanoTime() - startTime < howLong) {
            }
            this.setComplete(true);
        }

        public synchronized void setComplete(boolean isComplete) {
            this.isComplete = isComplete;
        }

        public synchronized boolean isComplete() {
            return this.isComplete;
        }
    }
}

