/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.clusterbench.common.session;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.test.clusterbench.common.SerialBean;

public class CommonHttpSessionServlet
extends HttpServlet {
    protected static final Logger log = Logger.getLogger(CommonHttpSessionServlet.class.getName());
    public static final String KEY = CommonHttpSessionServlet.class.getName();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession session = req.getSession(true);
        if (session.isNew()) {
            if (req.getParameter("cargokb") != null && req.getParameter("cargokb").matches("[0-9]+")) {
                log.log(Level.INFO, "New session created: {0} with {1}kB cargo", new Object[]{session.getId(), req.getParameter("cargokb")});
                int kargokb = Integer.parseInt(req.getParameter("cargokb"));
                session.setAttribute(KEY, this.createSerialBean(kargokb));
            } else {
                log.log(Level.INFO, "New session created: {0} with {1}kB cargo", new Object[]{session.getId(), 4});
                session.setAttribute(KEY, this.createSerialBean());
            }
        } else if (session.getAttribute(KEY) == null) {
            log.log(Level.INFO, "Session is not new, creating SerialBean: {0}", session.getId());
            session.setAttribute(KEY, this.createSerialBean());
        }
        SerialBean bean = (SerialBean)session.getAttribute(KEY);
        resp.setContentType("text/plain");
        if (req.getParameter("readonly") != null) {
            resp.getWriter().print(bean.getSerial());
            return;
        }
        int serial = bean.getSerial();
        bean.setSerial(serial + 1);
        session.setAttribute(KEY, (Object)bean);
        resp.getWriter().print(serial);
        if (req.getParameter("invalidate") != null) {
            log.log(Level.INFO, "Invalidating: {0}", session.getId());
            session.invalidate();
        }
    }

    private Object createSerialBean(int cargokbytes) {
        return new SerialBean(cargokbytes);
    }

    protected Object createSerialBean() {
        return new SerialBean();
    }

    public String getServletInfo() {
        return "Servlet using Session to store object with the serial.";
    }
}

