/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jms;

import java.io.IOException;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import org.jboss.logging.Logger;
import org.jboss.test.jms.JMSTestAdmin;
import org.jboss.test.jms.TestRole;

public class HornetQTestAdmin
extends JMSTestAdmin {
    private final MBeanServerConnection jmx;
    private static final Logger staticLog = Logger.getLogger(HornetQTestAdmin.class);
    protected final ObjectName hornetQJMSServerName = new ObjectName("org.hornetq:module=JMS,type=Server");
    protected final ObjectName hornetQCoreServerName = new ObjectName("org.hornetq:module=Core,type=Server");

    public HornetQTestAdmin() throws Exception {
        InitialContext ctx = new InitialContext();
        String adaptorName = System.getProperty("jbosstest.server.name", "jmx/invoker/RMIAdaptor");
        this.jmx = (MBeanServerConnection)ctx.lookup(adaptorName);
        ctx.close();
    }

    public void createQueue(String name, TestRole ... securityConfig) throws Exception {
        this.createQueue(name, new String[]{"/queue/" + name, name}, securityConfig);
    }

    private void addRoles(String address, TestRole[] securityConf) throws Exception {
        if (securityConf == null || securityConf.length == 0) {
            securityConf = new TestRole[]{new TestRole("guest", true, true, true)};
        }
        String sendRoles = "";
        String consumeRoles = "";
        String createDurableQueueRoles = "";
        String deleteDurableQueueRoles = "";
        String createTempQueueRoles = "";
        String deleteTempQueueRoles = "";
        String manageRoles = "";
        for (TestRole role : securityConf) {
            if (role.isSend()) {
                sendRoles = sendRoles + (sendRoles.isEmpty() ? role.getName() : "," + role.getName());
            }
            if (role.isConsume()) {
                consumeRoles = consumeRoles + (consumeRoles.isEmpty() ? role.getName() : "," + role.getName());
            }
            if (role.isCreateDurableQueue()) {
                createDurableQueueRoles = createDurableQueueRoles + (createDurableQueueRoles.isEmpty() ? role.getName() : "," + role.getName());
            }
            if (role.isDeleteDurableQueue()) {
                deleteDurableQueueRoles = deleteDurableQueueRoles + (deleteDurableQueueRoles.isEmpty() ? role.getName() : "," + role.getName());
            }
            if (role.isCreateNonDurableQueue()) {
                createTempQueueRoles = createTempQueueRoles + (createTempQueueRoles.isEmpty() ? role.getName() : "," + role.getName());
            }
            if (role.isDeleteNonDurableQueue()) {
                deleteTempQueueRoles = deleteTempQueueRoles + (deleteTempQueueRoles.isEmpty() ? role.getName() : "," + role.getName());
            }
            if (!role.isManage()) continue;
            manageRoles = manageRoles + (manageRoles.isEmpty() ? role.getName() : "," + role.getName());
        }
        this.jmx.invoke(this.hornetQCoreServerName, "addSecuritySettings", new Object[]{address, sendRoles, consumeRoles, createDurableQueueRoles, deleteDurableQueueRoles, createTempQueueRoles, deleteTempQueueRoles, manageRoles}, new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
    }

    private String getCoreAddress(boolean isTopic, String address) {
        address = isTopic ? "jms.topic." + address : "jms.queue." + address;
        return address;
    }

    private void resetRoles(boolean isTopic, String address) throws Exception {
        this.jmx.invoke(this.hornetQCoreServerName, "removeSecuritySettings", new Object[]{address}, new String[]{String.class.getName()});
    }

    public void createQueue(String name, String[] jndiArray, TestRole ... securityConfig) throws Exception {
        for (String jndi : jndiArray) {
            this.jmx.invoke(this.hornetQJMSServerName, "createQueue", new Object[]{name, jndi}, new String[]{"java.lang.String", "java.lang.String"});
        }
        this.addRoles(this.getCoreAddress(false, name), securityConfig);
        this.deployedQueues.put(name, securityConfig);
    }

    public void createTopic(String name, TestRole ... securityConfig) throws Exception {
        this.createTopic(name, new String[]{"/topic/" + name, name}, securityConfig);
    }

    public void createTopic(String name, String[] jndiArray, TestRole ... securityConfig) throws Exception {
        for (String jndi : jndiArray) {
            this.jmx.invoke(this.hornetQJMSServerName, "createTopic", new Object[]{name, jndi}, new String[]{"java.lang.String", "java.lang.String"});
        }
        this.addRoles(this.getCoreAddress(true, name), securityConfig);
        this.deployedTopics.put(name, securityConfig);
    }

    public void deleteQueue(String name) throws Exception {
        try {
            this.deployedQueues.remove(name);
            this.resetRoles(false, name);
            this.invokeDeleteQueue(name);
        }
        catch (Exception e) {
            staticLog.warn((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void deleteTopic(String name) throws Exception {
        try {
            this.deployedTopics.remove(name);
            this.resetRoles(true, name);
            this.invokeDeleteTopic(name);
        }
        catch (Exception e) {
            staticLog.warn((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void destroyEveryDestination() throws Exception {
        String[] topics;
        String[] queues;
        for (String queue : queues = (String[])this.jmx.getAttribute(this.hornetQJMSServerName, "QueueNames")) {
            if (queue.equals("DLQ") || queue.equals("ExpiryQueue")) continue;
            this.deleteQueue(queue);
        }
        for (String topic : topics = (String[])this.jmx.getAttribute(this.hornetQJMSServerName, "TopicNames")) {
            this.deleteTopic(topic);
        }
    }

    public void destroyCreatedDestinations() throws Exception {
        for (Map.Entry queue : this.deployedQueues.entrySet()) {
            this.resetRoles(false, (String)queue.getKey());
            try {
                this.invokeDeleteQueue((String)queue.getKey());
            }
            catch (Exception e) {
                staticLog.warn((Object)("Error deleting queue " + (String)queue.getKey()), (Throwable)e);
            }
        }
        for (Map.Entry topic : this.deployedTopics.entrySet()) {
            this.resetRoles(true, (String)topic.getKey());
            try {
                this.invokeDeleteTopic((String)topic.getKey());
            }
            catch (Exception e) {
                staticLog.warn((Object)("Error deleting topic " + (String)topic.getKey()), (Throwable)e);
            }
        }
        this.deployedQueues.clear();
        this.deployedTopics.clear();
    }

    private void invokeDeleteQueue(String name) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        this.jmx.invoke(this.hornetQJMSServerName, "destroyQueue", new Object[]{name}, new String[]{"java.lang.String"});
    }

    private void invokeDeleteTopic(String name) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        this.jmx.invoke(this.hornetQJMSServerName, "destroyTopic", new Object[]{name}, new String[]{"java.lang.String"});
    }

    public ObjectName createQueueJMXName(String queueName) {
        try {
            return new ObjectName("org.hornetq:module=JMS,name=\"" + queueName + "\",type=Queue");
        }
        catch (Exception e) {
            staticLog.warn((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public ObjectName createTopicJMXName(String queueName) {
        try {
            return new ObjectName("org.hornetq:module=JMS,name=\"" + queueName + "\",type=Topic");
        }
        catch (Exception e) {
            staticLog.warn((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }
}

