/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium;

import com.thoughtworks.selenium.SeleneseTestCase;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jboss.test.selenium.waiting.Condition;
import org.jboss.test.selenium.waiting.Retrieve;
import org.jboss.test.selenium.waiting.Wait;
import org.testng.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSeleniumTestCase {
    protected Properties locatorsProperties = this.getLocatorsProperties();
    protected Properties messagesProperties = this.getMessagesProperties();
    protected Selenium selenium;
    public static String PAGE_LOAD = "180000";
    public static long AJAX_LOAD = 3000L;
    public static int ELEM_TIMEOUT = 220;

    protected Properties getMessagesProperties() {
        return new Properties();
    }

    protected Properties getLocatorsProperties() {
        return new Properties();
    }

    protected static Properties getProperties(String resource) throws IOException {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        InputStream is = cl.getResourceAsStream(resource);
        Properties props = new Properties();
        if (is == null) {
            is = AbstractSeleniumTestCase.class.getResourceAsStream(resource);
        }
        if (is != null) {
            props.load(is);
        }
        return props;
    }

    protected <T> Properties getNamedPropertiesForClass(Class<T> tClass, String name) throws IllegalStateException {
        String propFile = tClass.getPackage().getName();
        propFile = propFile.replace('.', '/');
        propFile = String.format("%s/%s.properties", propFile, name);
        try {
            return AbstractSeleniumTestCase.getProperties(propFile);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getProperty(Properties properties, String property, String subst) {
        if (properties == null || properties.getProperty(property) == null) {
            if (StringUtils.isEmpty((String)subst)) {
                throw new IllegalStateException("property '" + property + "' wasn't found and substitution isn't set");
            }
            return subst;
        }
        return properties.getProperty(property);
    }

    @Deprecated
    public String getMess(String prop, String subst) {
        return this.getMsg(prop, subst);
    }

    @Deprecated
    public String getMess(String prop) {
        return this.getMsg(prop, null);
    }

    public String getMsg(String prop, String subst) {
        return this.getProperty(this.messagesProperties, prop, subst);
    }

    public String getMsg(String prop) {
        return this.getMsg(prop, null);
    }

    public String formatMsg(String prop, Object ... args) {
        return AbstractSeleniumTestCase.format(this.getMsg(prop, null), args);
    }

    public String getLoc(String prop, String subst) {
        return this.getProperty(this.locatorsProperties, prop, subst);
    }

    public String getLoc(String prop) {
        return this.getLoc(prop, null);
    }

    public String formatLoc(String prop, Object ... args) {
        return AbstractSeleniumTestCase.format(this.getLoc(prop, null), args);
    }

    public static String format(String format, Object ... args) {
        String message = AbstractSeleniumTestCase.preformat(format);
        return MessageFormat.format(message, args);
    }

    private static String preformat(String message) {
        return message.replace("'", "''").replace("\\''", "'");
    }

    public void clickIfVisible(String id) {
        if (this.selenium.isElementPresent(id)) {
            this.selenium.click(id);
            this.selenium.waitForPageToLoad(PAGE_LOAD);
        }
    }

    public int findTableRow(String tableLocation, String searchName, int searchCol) {
        return Integer.valueOf(this.selenium.getEval("selenium.findTableRow(\"" + tableLocation + "\",'" + searchName + "'," + searchCol + ")"));
    }

    public int countTableRows(String tableLocation) {
        return Integer.valueOf(this.selenium.getEval("selenium.countTableRows(\"" + tableLocation + "\")"));
    }

    public void safeSelect(String locator, String value) {
        this.waitForElement(locator);
        int second = 0;
        while (true) {
            if (second >= ELEM_TIMEOUT) {
                Assert.fail((String)("Element " + locator + " not found."));
            }
            try {
                String[] opts = this.selenium.getSelectOptions(locator);
                boolean isAvailable = false;
                for (String opt : opts) {
                    if (!opt.equals(value)) continue;
                    isAvailable = true;
                }
                if (isAvailable) {
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.waitFor(1000L);
            ++second;
        }
        this.selenium.select(locator, "label=" + value);
    }

    public void clickAndWait(String locator) {
        this.waitForElement(locator);
        this.selenium.click(locator);
        this.selenium.waitForPageToLoad(PAGE_LOAD);
    }

    public void openAndWait(String locator) {
        this.selenium.open(locator);
        this.selenium.waitForPageToLoad(PAGE_LOAD);
    }

    public void selectIfNotSelected(String selector, String label) {
        this.waitForElement(selector);
        if (!this.selenium.getSelectedLabel(selector).equals(label)) {
            this.selenium.select(selector, "label=" + label);
            this.selenium.waitForPageToLoad(PAGE_LOAD);
        }
    }

    public boolean assertTextOrder(String text) {
        return Boolean.valueOf(this.selenium.getEval("selenium.assertTextOrder(\"" + text + "\")"));
    }

    public void waitFor(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void waitForElement(String locator) {
        this.waitForElement(locator, 1000);
    }

    public void waitForElement(final String locator, int step) {
        Wait.failWith("Element \"" + locator + "\" not found.").interval(step).timeout(ELEM_TIMEOUT).until(new Condition(){

            public boolean isTrue() {
                return AbstractSeleniumTestCase.this.selenium.isElementPresent(locator);
            }
        });
    }

    public void waitForElement(String locatorElem, long timeToWait) {
        int i = 0;
        while (true) {
            if ((long)(i * 500) >= timeToWait) {
                Assert.fail((String)("Element " + locatorElem + " not found."));
            }
            try {
                if (this.selenium.isElementPresent(locatorElem)) {
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.waitFor(500L);
            ++i;
        }
    }

    @Deprecated
    public void waitForElement(String locatorElem, String locatorLink, long timeToWait, long n) {
        int i = 0;
        while (true) {
            if ((long)i >= n) {
                Assert.fail((String)("Element " + locatorElem + " not found."));
            }
            try {
                if (this.selenium.isElementPresent(locatorElem)) {
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.waitFor(1000L);
            ++i;
        }
    }

    public void waitForText(String text) {
        int second = 0;
        while (true) {
            if (second >= ELEM_TIMEOUT) {
                Assert.fail((String)("Text '" + text + "' not found."));
            }
            try {
                if (this.selenium.isTextPresent(text)) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.waitFor(100L);
            ++second;
        }
    }

    public void waitForTextEquals(final String locator, final String pattern) {
        Wait.until(new Condition(){

            public boolean isTrue() {
                return SeleneseTestCase.seleniumEquals((String)AbstractSeleniumTestCase.this.selenium.getText(locator), (String)pattern);
            }
        });
    }

    public void waitForTextChanges(String locator, String lastText) {
        this.waitForTextChangesAndReturn(locator, lastText);
    }

    public String waitForTextChangesAndReturn(final String locator, String lastText) {
        return Wait.waitForChangeAndReturn(lastText, new Retrieve<String>(){

            @Override
            public String retrieve() {
                return AbstractSeleniumTestCase.this.selenium.getText(locator);
            }
        });
    }

    public void waitForAttributeChanges(String attributeLocator, String attributeValue) {
        this.waitForAttributeChangesAndReturn(attributeLocator, attributeValue);
    }

    public String waitForAttributeChangesAndReturn(final String attributeLocator, String attributeValue) {
        return Wait.waitForChangeAndReturn(attributeValue, new Retrieve<String>(){

            @Override
            public String retrieve() {
                return AbstractSeleniumTestCase.this.selenium.getAttribute(attributeLocator);
            }
        });
    }

    public String getStyle(String locator, String property) {
        String evaluate = MessageFormat.format("selenium.getStyle(\"{0}\", \"{1}\")", locator, property);
        String result = null;
        try {
            result = this.selenium.getEval(evaluate);
        }
        catch (Exception e) {
            if ("ERROR: Threw an exception: null property value".equals(e.getMessage())) {
                return null;
            }
            throw new SeleniumException(e);
        }
        return result;
    }

    public void scrollIntoView(String locator, boolean alignToTop) {
        String evaluate = MessageFormat.format("selenium.scrollIntoView(\"{0}\", {1})", locator, Boolean.toString(alignToTop));
        this.selenium.getEval(evaluate);
    }

    public int getJQueryCount(String selector) {
        String evaluate = AbstractSeleniumTestCase.format("selenium.getJQueryCount(\"{0}\")", selector.replaceFirst("^jquery=", ""));
        String result = this.selenium.getEval(evaluate);
        return Integer.parseInt(result);
    }

    public boolean belongsClass(String className, String locator) {
        Validate.notNull((Object)className);
        Validate.notNull((Object)locator);
        String classLocator = AbstractSeleniumTestCase.format("{0}@class", locator);
        String classNames = this.getAttributeOrNull(classLocator);
        if (classNames == null) {
            return false;
        }
        String regex = AbstractSeleniumTestCase.format("(?:^|.*\\s){0}(?:$|\\s.*)", className);
        return classNames.matches(regex);
    }

    public boolean isDisplayed(String locator) {
        try {
            return !this.getStyle(locator, "display").contains("none");
        }
        catch (Exception e) {
            return true;
        }
    }

    public void mouseOverAt(String locator, String coordString) {
        this.selenium.getEval(AbstractSeleniumTestCase.format("selenium.doMouseOverAt(\"{0}\", \"{1}\")", locator, coordString));
    }

    public String getTextOrNull(String locator) {
        try {
            return this.selenium.getEval(AbstractSeleniumTestCase.format("selenium.getTextOrNull(\"{0}\")", locator));
        }
        catch (RuntimeException e) {
            if ("ERROR: Threw an exception: element is not found".equals(e.getMessage())) {
                return null;
            }
            throw e;
        }
    }

    public String getAttributeOrNull(String attributeLocator) {
        try {
            return this.selenium.getAttribute(attributeLocator);
        }
        catch (Exception e) {
            if (e.getMessage().startsWith("ERROR: Could not find element attribute:") || e.getMessage().matches("^ERROR: Element .* not found$")) {
                return null;
            }
            throw new IllegalStateException("getAttributeOrNull unexpected state - " + e.getMessage(), e);
        }
    }

    public void addRequiredScript(String script) {
        String escapedScript = StringEscapeUtils.escapeJavaScript((String)script);
        String id = "selenium_script_" + Integer.toString(escapedScript.hashCode());
        if (this.selenium.isElementPresent(id)) {
            return;
        }
        this.selenium.getEval(AbstractSeleniumTestCase.format("selenium.addScriptLocally('{0}', '{1}')", id, escapedScript));
    }

    public String removeJQueryPrefix(String jqueryLocator) {
        String prefix = "jquery=";
        if (jqueryLocator.startsWith("jquery=")) {
            return jqueryLocator.replaceFirst("jquery=", "");
        }
        throw new IllegalArgumentException(AbstractSeleniumTestCase.format("Given locator '{0}' isn't valid jQuery locator (doesn't start with '{1}')", jqueryLocator, "jquery="));
    }
}

