/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.actions;

import com.thoughtworks.selenium.Selenium;
import org.jboss.test.selenium.waiting.Wait;

public class Drag {
    private int phase = 0;
    private Selenium selenium;
    private String item;
    private String target;
    private int x;
    private int y;
    private final int STEPS = 5;
    private final int FIRST_STEP = 2;
    private final Wait.Waiting wait = Wait.timeout(10L);

    public Drag(Selenium selenium, String item, String target) {
        this.selenium = selenium;
        this.item = item;
        this.target = target;
        this.x = selenium.getElementPositionLeft(target).intValue() - selenium.getElementPositionLeft(item).intValue();
        this.y = selenium.getElementPositionTop(target).intValue() - selenium.getElementPositionTop(item).intValue();
    }

    public void start() {
        this.process(0);
    }

    public void mouseOut() {
        this.process(1);
    }

    public void move() {
        this.process(2);
    }

    public void enter() {
        this.process(3);
    }

    public void drop() {
        this.process(4);
    }

    private void process(int request) {
        if (request < this.phase) {
            throw new RuntimeException();
        }
        switch (this.phase) {
            case 0: {
                this.selenium.mouseDown(this.item);
                String moveCoords = this.coords(this.x < 0 ? 2 : -2, this.y < 0 ? 2 : -2);
                this.selenium.mouseMoveAt(this.item, moveCoords);
                if (request < ++this.phase) break;
            }
            case 1: {
                this.selenium.mouseOut(this.item);
                if (request < ++this.phase) break;
            }
            case 2: {
                for (int i = 0; i < 5; ++i) {
                    this.selenium.mouseMoveAt(this.item, this.coords(this.x * i / 5, this.y * i / 5));
                    this.wait.waitForTimeout();
                }
                if (request < ++this.phase) break;
            }
            case 3: {
                this.selenium.mouseMoveAt(this.item, this.coords(this.x, this.y));
                this.selenium.mouseOver(this.target);
                if (request < ++this.phase) break;
            }
            case 4: {
                this.selenium.mouseUp(this.target);
                if (request >= ++this.phase) break;
            }
        }
    }

    private String coords(int x, int y) {
        return String.format("%d,%d", x, y);
    }
}

