/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.utils;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;

public class ColorUtils {
    public static int convertToInteger(String colorValue) {
        Validate.notNull((Object)colorValue);
        int result = 0;
        if (colorValue.charAt(0) == '#') {
            result = Integer.parseInt(colorValue.substring(1), 16);
        } else {
            Matcher matcher = Pattern.compile("(\\d+)").matcher(colorValue);
            for (int i = 1; i <= 3; ++i) {
                if (!matcher.find()) {
                    throw new IllegalArgumentException(colorValue);
                }
                if (i != 1) {
                    result <<= 8;
                }
                result |= 0xFF & Short.parseShort(matcher.group(1));
            }
        }
        return result;
    }

    public static Color convertToAWTColor(String colorValue) {
        if (colorValue == null) {
            return null;
        }
        int convertedValue = ColorUtils.convertToInteger(colorValue);
        return new Color(convertedValue);
    }
}

