/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.utils;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class URLUtils {
    public static String buildUrl(String context, String ... relocations) throws MalformedURLException {
        URL url = new URL(context);
        for (String move : relocations) {
            url = new URL(url, move);
        }
        return url.toString();
    }

    public static String resourceMd5Digest(String url) throws IOException {
        MessageDigest digest;
        URLConnection connection = new URL(url).openConnection();
        InputStream in = connection.getInputStream();
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("MD5 hashing is unsupported", ex);
        }
        byte[] buffer = new byte[8192];
        int read = 0;
        while ((read = in.read(buffer)) > 0) {
            digest.update(buffer, 0, read);
        }
        byte[] md5sum = digest.digest();
        BigInteger bigInt = new BigInteger(1, md5sum);
        return bigInt.toString(16);
    }
}

