/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.waiting;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.test.selenium.AbstractSeleniumTestCase;
import org.jboss.test.selenium.waiting.Condition;
import org.jboss.test.selenium.waiting.Retrieve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wait {
    public static final long DEFAULT_INTERVAL = 500L;
    public static final long DEFAULT_TIMEOUT = 30000L;

    private Wait() {
    }

    public static Waiting getDefault() {
        return Waiting.getInstance();
    }

    public static Waiting interval(long interval) {
        return Wait.getDefault().interval(interval);
    }

    public static Waiting timeout(long timeout) {
        return Wait.getDefault().timeout(timeout);
    }

    public static Waiting failWith(Object failureSubject) {
        return Wait.getDefault().failWith(failureSubject);
    }

    public static Waiting failWith(CharSequence failureMessage, Object ... args) {
        return Wait.getDefault().failWith(failureMessage, args);
    }

    public static Waiting dontFail() {
        return Wait.getDefault().dontFail();
    }

    public static Waiting noDelay() {
        return Wait.getDefault().withDelay(false);
    }

    public static Waiting withDelay(boolean isDelayed) {
        return Wait.getDefault().withDelay(isDelayed);
    }

    public static void waitForTimeout() {
        Wait.getDefault().waitForTimeout();
    }

    public static <T> void waitForChange(T oldValue, Retrieve<T> retrieve) {
        Wait.getDefault().waitForChangeAndReturn(oldValue, retrieve);
    }

    public static <T> T waitForChangeAndReturn(T oldValue, Retrieve<T> retrieve) {
        return Wait.getDefault().waitForChangeAndReturn(oldValue, retrieve);
    }

    public static void waitFor(long timeoutInMilis) {
        Wait.getDefault().timeout(timeoutInMilis).waitForTimeout();
    }

    public static void until(Condition condition) {
        Wait.getDefault().until(condition);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Waiting {
        private long interval = 500L;
        private long timeout = 30000L;
        public boolean isDelayed = true;
        private Object failure = new AssertionError();
        private Object[] failureArgs;
        private static final AtomicReference<Waiting> singleton = new AtomicReference<Object>(null);

        private static Waiting getInstance() {
            if (singleton.get() == null) {
                singleton.compareAndSet(null, new Waiting());
            }
            return singleton.get();
        }

        private Waiting() {
        }

        public Waiting interval(long interval) {
            if (interval == this.interval) {
                return this;
            }
            Waiting copy = this.copy();
            copy.interval = interval;
            return copy;
        }

        public Waiting timeout(long timeout) {
            if (timeout == this.timeout) {
                return this;
            }
            Waiting copy = this.copy();
            copy.timeout = timeout;
            return copy;
        }

        public Waiting failWith(Object failureSubject) {
            if (failureSubject == null && this.failure == null) {
                return this;
            }
            Waiting copy = this.copy();
            copy.failure = failureSubject;
            copy.failureArgs = null;
            return copy;
        }

        public Waiting failWith(CharSequence failureMessage, Object ... args) {
            Waiting copy = this.copy();
            copy.failure = failureMessage;
            copy.failureArgs = args;
            return copy;
        }

        protected RuntimeException processFailure() {
            if (this.failure instanceof RuntimeException) {
                return (RuntimeException)this.failure;
            }
            if (this.failure instanceof CharSequence) {
                return new WaitTimeoutException((CharSequence)this.failure, this.failureArgs);
            }
            return new WaitTimeoutException(this.failure);
        }

        public Waiting dontFail() {
            return this.failWith(null);
        }

        public Waiting noDelay() {
            return this.withDelay(false);
        }

        public Waiting withDelay(boolean isDelayed) {
            if (isDelayed == this.isDelayed) {
                return this;
            }
            Waiting copy = this.copy();
            copy.isDelayed = isDelayed;
            return copy;
        }

        public void until(Condition condition) {
            long start = System.currentTimeMillis();
            long end = start + this.timeout;
            boolean delay = this.isDelayed;
            while (System.currentTimeMillis() < end) {
                if (!delay && condition.isTrue()) {
                    return;
                }
                delay = false;
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (System.currentTimeMillis() < end || !condition.isTrue()) continue;
                return;
            }
            this.fail();
        }

        public void waitForTimeout() {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public <T> void waitForChange(T oldValue, Retrieve<T> retrieve) {
            this.waitForChangeAndReturn(oldValue, retrieve);
        }

        public <T> T waitForChangeAndReturn(final T oldValue, final Retrieve<T> retrieve) {
            final Vector vector = new Vector(1);
            this.until(new Condition(){

                public boolean isTrue() {
                    vector.add(0, retrieve.retrieve());
                    if (oldValue == null) {
                        return vector.get(0) != null;
                    }
                    return !oldValue.equals(vector.get(0));
                }
            });
            return (T)vector.get(0);
        }

        private void fail() {
            if (this.failure != null) {
                throw this.processFailure();
            }
        }

        private Waiting copy() {
            Waiting copy = new Waiting();
            copy.interval = this.interval;
            copy.timeout = this.timeout;
            copy.failure = this.failure;
            copy.failureArgs = this.failureArgs;
            copy.isDelayed = this.isDelayed;
            return copy;
        }

        protected static class WaitTimeoutException
        extends RuntimeException {
            private static final long serialVersionUID = 6056785264760499779L;
            private Object failure = "Waiting timed out";

            public WaitTimeoutException(Object failure) {
                if (failure != null) {
                    this.failure = failure;
                }
            }

            public WaitTimeoutException(CharSequence message, Object ... args) {
                this.failure = AbstractSeleniumTestCase.format(((Object)message).toString(), args);
            }

            public Throwable getCause() {
                if (this.failure instanceof Throwable) {
                    return (Throwable)this.failure;
                }
                return super.getCause();
            }

            public String getMessage() {
                if (this.failure instanceof Throwable) {
                    return ((Throwable)this.failure).getMessage();
                }
                return this.failure.toString();
            }
        }
    }
}

