/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.guard.request;

import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.guard.request.RequestType;
import org.jboss.test.selenium.guard.request.RequestTypeGuard;

public final class RequestTypeGuardFactory {
    private RequestTypeGuardFactory() {
    }

    private static AjaxSelenium guard(AjaxSelenium selenium, RequestType requestExpected) {
        AjaxSelenium copy = selenium.immutableCopy();
        copy.getInterceptionProxy().unregisterInterceptorType(RequestTypeGuard.class);
        copy.getInterceptionProxy().registerInterceptor(new RequestTypeGuard(requestExpected));
        return copy;
    }

    public static AjaxSelenium guardXhr(AjaxSelenium selenium) {
        return RequestTypeGuardFactory.guard(selenium, RequestType.XHR);
    }

    public static AjaxSelenium guardHttp(AjaxSelenium selenium) {
        return RequestTypeGuardFactory.guard(selenium, RequestType.HTTP);
    }

    public static AjaxSelenium guardNoRequest(AjaxSelenium selenium) {
        return RequestTypeGuardFactory.guard(selenium, RequestType.NONE);
    }
}

