/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.interception;

import com.thoughtworks.selenium.CommandProcessor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.test.selenium.interception.CommandContext;
import org.jboss.test.selenium.interception.CommandInterceptionException;
import org.jboss.test.selenium.interception.CommandInterceptor;

public final class InterceptionProxy
implements InvocationHandler {
    CommandProcessor commandProcessor;
    private Map<Class<? extends CommandInterceptor>, CommandInterceptor> interceptors = new LinkedHashMap<Class<? extends CommandInterceptor>, CommandInterceptor>();

    public InterceptionProxy(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public CommandProcessor getCommandProcessorProxy() {
        return (CommandProcessor)Proxy.newProxyInstance(this.commandProcessor.getClass().getClassLoader(), this.commandProcessor.getClass().getInterfaces(), (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        block7: {
            try {
                if ("doCommand".equals(method.getName())) {
                    String commandName = (String)args[0];
                    String[] arguments = (String[])args[1];
                    CommandContext context = new CommandContext(commandName, arguments, this.commandProcessor, this.interceptors.values());
                    try {
                        result = context.doCommand();
                        break block7;
                    }
                    catch (CommandInterceptionException e) {
                        throw new IllegalStateException("There was at least one interceptor which didn't call doCommand");
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                result = method.invoke((Object)this.commandProcessor, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
            }
        }
        return result;
    }

    public void registerInterceptor(CommandInterceptor interceptor) {
        this.interceptors.put(interceptor.getClass(), interceptor);
    }

    public CommandInterceptor unregisterInterceptor(CommandInterceptor interceptor) {
        Class<? extends CommandInterceptor> typeToRemove = null;
        for (Map.Entry<Class<? extends CommandInterceptor>, CommandInterceptor> entry : this.interceptors.entrySet()) {
            if (!entry.getValue().equals(interceptor)) continue;
            typeToRemove = entry.getKey();
            break;
        }
        return this.interceptors.remove(typeToRemove);
    }

    public Set<CommandInterceptor> unregisterInterceptorType(Class<? extends CommandInterceptor> type) {
        LinkedHashSet<Class<? extends CommandInterceptor>> typesToRemove = new LinkedHashSet<Class<? extends CommandInterceptor>>();
        for (Class<? extends CommandInterceptor> entryType : this.interceptors.keySet()) {
            if (!entryType.isInstance(type)) continue;
            typesToRemove.add(entryType);
        }
        LinkedHashSet<CommandInterceptor> removedInterceptors = new LinkedHashSet<CommandInterceptor>();
        for (Class clazz : typesToRemove) {
            removedInterceptors.add(this.interceptors.remove(clazz));
        }
        return removedInterceptors;
    }

    public InterceptionProxy immutableCopy() {
        InterceptionProxy copy = new InterceptionProxy(this.commandProcessor);
        copy.interceptors.putAll(this.interceptors);
        return copy;
    }
}

