/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.utils.testng;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.ITestResult;

public final class TestInfo {
    public static final Map<Integer, String> STATUSES = Collections.unmodifiableMap(new TreeMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(2, "Failure");
            this.put(3, "Skip");
            this.put(16, "Started");
            this.put(1, "Success");
            this.put(4, "FailurePercentage");
        }
    });

    private TestInfo() {
    }

    public static String getMethodName(ITestResult result) {
        String methodName = result.getMethod().toString();
        Matcher matcher = Pattern.compile("(?:.*\\.)?(.*\\..*)\\(.*\\)").matcher(methodName);
        if (matcher.lookingAt()) {
            methodName = matcher.group(1);
        }
        return methodName;
    }
}

