/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.waiting.selenium;

import java.util.Vector;
import org.jboss.test.selenium.waiting.DefaultWaiting;
import org.jboss.test.selenium.waiting.selenium.SeleniumCondition;
import org.jboss.test.selenium.waiting.selenium.SeleniumRetriever;

public class SeleniumWaiting
extends DefaultWaiting<SeleniumWaiting> {
    public void until(SeleniumCondition condition) {
        long start = System.currentTimeMillis();
        long end = start + this.getTimeout();
        boolean delay = this.isDelayed();
        while (System.currentTimeMillis() < end) {
            if (!delay && condition.isTrue()) {
                return;
            }
            delay = false;
            try {
                Thread.sleep(this.getInterval());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (System.currentTimeMillis() < end || !condition.isTrue()) continue;
            return;
        }
        this.fail();
    }

    public <T> void waitForChange(T oldValue, SeleniumRetriever<T> retrieve) {
        this.waitForChangeAndReturn(oldValue, retrieve);
    }

    public <T> T waitForChangeAndReturn(final T oldValue, final SeleniumRetriever<T> retrieve) {
        final Vector vector = new Vector(1);
        this.until(new SeleniumCondition(){

            @Override
            public boolean isTrue() {
                vector.add(0, retrieve.retrieve());
                if (oldValue == null) {
                    return vector.get(0) != null;
                }
                return !oldValue.equals(vector.get(0));
            }
        });
        return (T)vector.get(0);
    }
}

