/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium;

import java.io.File;
import java.net.URL;
import org.jboss.test.selenium.browser.Browser;
import org.jboss.test.selenium.utils.PrimitiveUtils;
import org.jboss.test.selenium.utils.URLUtils;

public final class SystemProperties {
    private SystemProperties() {
    }

    public static URL getContextRoot() {
        return URLUtils.buildUrl(System.getProperty("context.root"), new String[0]);
    }

    public static URL getContextPath() {
        return URLUtils.buildUrl(SystemProperties.getContextRoot(), System.getProperty("context.path"));
    }

    public static Browser getBrowser() {
        return new Browser(System.getProperty("browser"));
    }

    public static File getMavenResourcesDir() {
        return new File(System.getProperty("maven.resources.dir"));
    }

    public static File getMavenProjectBuildDirectory() {
        return new File(System.getProperty("maven.project.build.directory"));
    }

    public static String getSeleniumHost() {
        return System.getProperty("selenium.host");
    }

    public static int getSeleniumPort() {
        return PrimitiveUtils.asInteger(System.getProperty("selenium.port"));
    }

    public static boolean isSeleniumMaximize() {
        return PrimitiveUtils.asBoolean(System.getProperty("selenium.maximize"));
    }

    public static boolean isSeleniumDebug() {
        return PrimitiveUtils.asBoolean(System.getProperty("selenium.debug"));
    }

    public static long getSeleniumTimeout(SeleniumTimeoutType type) {
        return PrimitiveUtils.asLong(System.getProperty("selenium.timeout." + type.toString().toLowerCase()));
    }

    public static enum SeleniumTimeoutType {
        DEFAULT,
        GUI,
        AJAX,
        MODEL;

    }
}

