/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.browser;

import java.util.EnumSet;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.jboss.test.selenium.browser.BrowserType;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;

public enum BrowserMode {
    FIREFOX_PROXY(BrowserType.FIREFOX, "firefoxproxy"),
    FIREFOX(BrowserType.FIREFOX, "firefox"),
    CHROME(BrowserType.FIREFOX, "chrome"),
    FIREFOX_CHROME(BrowserType.FIREFOX, "firefoxchrome"),
    FIREFOX2(BrowserType.FIREFOX, "firefox2"),
    FIREFOX3(BrowserType.FIREFOX, "firefox3"),
    IEXPLORE_PROXY(BrowserType.IEXPLORE, "iexploreproxy"),
    SAFARI(BrowserType.SAFARI, "safari"),
    SAFARI_PROXY(BrowserType.SAFARI, "safariproxy"),
    IEXPLORE_HTA(BrowserType.IEXPLORE, "iehta"),
    IEXPLORE(BrowserType.IEXPLORE, "iexplore"),
    OPERA(BrowserType.OPERA, "opera"),
    IEXPLORE_PROXY_INJECTION(BrowserType.IEXPLORE, "piiexplore"),
    FIREFOX_PROXY_INJECTION(BrowserType.FIREFOX, "pifirefox"),
    KONQUEROR(BrowserType.KONQUEROR, "konqueror"),
    MOCK(BrowserType.MOCK, "mock"),
    GOOGLE_CHROME(BrowserType.GOOGLE_CHROME, "googlechrome"),
    SAFARI_PROXY_INJECTION(BrowserType.SAFARI, "pisafari");

    private String mode;
    private BrowserType browserType;

    private BrowserMode(BrowserType browserType, String mode) {
        this.mode = mode;
        this.browserType = browserType;
    }

    public static BrowserMode parseMode(String browserMode) {
        for (BrowserMode value : BrowserMode.values()) {
            if (!value.mode.equals(browserMode)) continue;
            return value;
        }
        throw new IllegalArgumentException(SimplifiedFormat.format("The browser defined by mode '{0}' isn't supported", browserMode));
    }

    public static EnumSet<BrowserMode> parseModes(String browserModesEnumeration) {
        HashSet<BrowserMode> modes = new HashSet<BrowserMode>();
        for (String mode : StringUtils.split((String)browserModesEnumeration, (String)", ")) {
            if ("*".equals(mode)) {
                return EnumSet.allOf(BrowserMode.class);
            }
            modes.add(BrowserMode.parseMode(mode));
        }
        if (modes.isEmpty()) {
            return EnumSet.noneOf(BrowserMode.class);
        }
        return EnumSet.copyOf(modes);
    }

    public static EnumSet<BrowserMode> getModesFromTypes(EnumSet<BrowserType> types) {
        HashSet<BrowserMode> list = new HashSet<BrowserMode>();
        for (BrowserMode mode : BrowserMode.values()) {
            if (!types.contains((Object)mode.getBrowserType())) continue;
            list.add(mode);
        }
        return EnumSet.copyOf(list);
    }

    public String getMode() {
        return "*" + this.mode;
    }

    public BrowserType getBrowserType() {
        return this.browserType;
    }
}

