/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.framework;

import com.thoughtworks.selenium.Selenium;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.jboss.test.selenium.SystemProperties;
import org.jboss.test.selenium.dom.Event;
import org.jboss.test.selenium.encapsulated.Cookie;
import org.jboss.test.selenium.encapsulated.CookieParameters;
import org.jboss.test.selenium.encapsulated.Frame;
import org.jboss.test.selenium.encapsulated.FrameLocator;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.encapsulated.Kwargs;
import org.jboss.test.selenium.encapsulated.LogLevel;
import org.jboss.test.selenium.encapsulated.NetworkTraffic;
import org.jboss.test.selenium.encapsulated.NetworkTrafficType;
import org.jboss.test.selenium.encapsulated.Window;
import org.jboss.test.selenium.encapsulated.WindowId;
import org.jboss.test.selenium.encapsulated.XpathLibrary;
import org.jboss.test.selenium.framework.TypedSelenium;
import org.jboss.test.selenium.framework.internal.UnsupportedTypedSelenium;
import org.jboss.test.selenium.geometry.Dimension;
import org.jboss.test.selenium.geometry.Offset;
import org.jboss.test.selenium.geometry.Point;
import org.jboss.test.selenium.locator.Attribute;
import org.jboss.test.selenium.locator.AttributeLocator;
import org.jboss.test.selenium.locator.ElementLocator;
import org.jboss.test.selenium.locator.IdLocator;
import org.jboss.test.selenium.locator.IterableLocator;
import org.jboss.test.selenium.locator.LocatorUtils;
import org.jboss.test.selenium.locator.XpathLocator;
import org.jboss.test.selenium.locator.type.LocationStrategy;
import org.jboss.test.selenium.utils.array.ArrayTransform;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;

public class TypedSeleniumImpl
implements TypedSelenium,
UnsupportedTypedSelenium {
    Selenium selenium;
    private ArrayTransform<String, Integer> transformArrayOfStringToInteger = new ArrayTransform<String, Integer>(Integer.class){

        @Override
        public Integer transformation(String source) {
            return Integer.valueOf(source);
        }
    };

    @Override
    public void addCustomRequestHeader(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLocationStrategy(LocationStrategy locationStrategy, JavaScript strategyDefinition) {
        this.selenium.addLocationStrategy(locationStrategy.getStrategyName(), strategyDefinition.toString());
    }

    @Override
    public void addScript(JavaScript javaScript) {
        this.selenium.addScript(javaScript.getAsString(), javaScript.getIdentification());
    }

    @Override
    public void addSelection(ElementLocator elementLocator, ElementLocator optionLocator) {
        this.selenium.addSelection(elementLocator.getAsString(), optionLocator.getAsString());
    }

    @Override
    public void allowNativeXpath(boolean allow) {
        this.selenium.allowNativeXpath(String.valueOf(allow));
    }

    @Override
    public void altKeyDown() {
        this.selenium.altKeyDown();
    }

    @Override
    public void altKeyUp() {
        this.selenium.altKeyUp();
    }

    @Override
    public void answerOnNextPrompt(String answer) {
        this.selenium.answerOnNextPrompt(answer);
    }

    @Override
    public IdLocator assignId(ElementLocator elementLocator, String identifier) {
        this.selenium.assignId(elementLocator.getAsString(), identifier);
        return new IdLocator(identifier);
    }

    @Override
    public void attachFile(ElementLocator fieldLocator, File fileLocator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void attachFile(ElementLocator fieldLocator, URL fileLocator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void captureEntirePageScreenshot(File filename, Kwargs kwargs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BufferedImage captureEntirePageScreenshot(Kwargs kwargs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NetworkTraffic captureNetworkTraffic(NetworkTrafficType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void captureScreenshot(File filename) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BufferedImage captureScreenshot() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void check(ElementLocator elementLocator) {
        this.selenium.check(elementLocator.getAsString());
    }

    @Override
    public void chooseCancelOnNextConfirmation() {
        this.selenium.chooseCancelOnNextConfirmation();
    }

    @Override
    public void chooseOkOnNextConfirmation() {
        this.selenium.chooseOkOnNextConfirmation();
    }

    @Override
    public void click(ElementLocator elementLocator) {
        this.selenium.click(elementLocator.getAsString());
    }

    @Override
    public void clickAt(ElementLocator elementLocator, Point point) {
        this.selenium.clickAt(elementLocator.getAsString(), point.getCoords());
    }

    @Override
    public void close() {
        this.selenium.close();
    }

    @Override
    public boolean containsScript(JavaScript javaScript) {
        String identification = javaScript.getIdentification();
        String evaluated = this.selenium.getEval(SimplifiedFormat.format("document.getElementById('{0}') ? true : false", identification));
        return Boolean.valueOf(evaluated);
    }

    @Override
    public void contextMenu(ElementLocator elementLocator) {
        this.selenium.contextMenu(elementLocator.getAsString());
    }

    @Override
    public void contextMenuAt(ElementLocator elementLocator, Point point) {
        this.selenium.contextMenuAt(elementLocator.getAsString(), point.getCoords());
    }

    @Override
    public void controlKeyDown() {
        this.selenium.controlKeyDown();
    }

    @Override
    public void controlKeyUp() {
        this.selenium.controlKeyUp();
    }

    @Override
    public void createCookie(Cookie cookie, CookieParameters parameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteAllVisibleCookies() {
        this.selenium.deleteAllVisibleCookies();
    }

    @Override
    public void deleteCookie(Cookie cookie, CookieParameters parameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deselectPopUp() {
        this.selenium.deselectPopUp();
    }

    @Override
    public void doubleClick(ElementLocator elementLocator) {
        this.selenium.doubleClick(elementLocator.getAsString());
    }

    @Override
    public void doubleClickAt(ElementLocator elementLocator, Point point) {
        this.selenium.doubleClickAt(elementLocator.getAsString(), point.getCoords());
    }

    @Override
    public void dragAndDrop(ElementLocator elementLocator, Offset offset) {
        this.selenium.dragAndDrop(elementLocator.getAsString(), offset.getMovement());
    }

    @Override
    public void dragAndDropToObject(ElementLocator elementLocatorOfObjectToBeDragged, ElementLocator elementLocatorOfDragDestinationObject) {
        this.selenium.dragAndDropToObject(elementLocatorOfDragDestinationObject.getAsString(), elementLocatorOfObjectToBeDragged.getAsString());
    }

    @Override
    public void dragdrop(ElementLocator elementLocator, Offset offset) {
        this.selenium.dragdrop(elementLocator.getAsString(), offset.getMovement());
    }

    @Override
    public void fireEvent(ElementLocator elementLocator, Event event) {
        this.selenium.fireEvent(elementLocator.getAsString(), event.getEventName());
    }

    @Override
    public void focus(ElementLocator elementLocator) {
        this.selenium.focus(elementLocator.getAsString());
    }

    @Override
    public String getAlert() {
        return this.selenium.getAlert();
    }

    @Override
    public List<ElementLocator> getAllButtons() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ElementLocator> getAllFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ElementLocator> getAllLinks() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<WindowId> getAllWindowIds() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getAllWindowNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getAllWindowTitles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttribute(AttributeLocator attributeLocator) {
        return this.selenium.getAttribute(attributeLocator.getAsString());
    }

    @Override
    public List<String> getAttributeFromAllWindows(Attribute attribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getBodyText() {
        return this.selenium.getBodyText();
    }

    @Override
    public String getConfirmation() {
        return this.selenium.getConfirmation();
    }

    @Override
    public List<Cookie> getCookie() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cookie getCookieByName(Cookie name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getCount(IterableLocator<?> locator) {
        IterableLocator<?> reference = locator;
        if (reference instanceof XpathLocator) {
            return this.selenium.getXpathCount(LocatorUtils.getRawLocator((XpathLocator)reference)).intValue();
        }
        throw new UnsupportedOperationException("Only XPath locator is supported for counting");
    }

    @Override
    public int getCursorPosition(ElementLocator elementLocator) {
        return this.selenium.getCursorPosition(elementLocator.getAsString()).intValue();
    }

    @Override
    public Dimension getElementDimension(ElementLocator elementLocator) {
        return new Dimension(this.getElementHeight(elementLocator), this.getElementWidth(elementLocator));
    }

    @Override
    public int getElementHeight(ElementLocator elementLocator) {
        return this.selenium.getElementHeight(elementLocator.getAsString()).intValue();
    }

    @Override
    public int getElementIndex(ElementLocator elementLocator) {
        return this.selenium.getElementIndex(elementLocator.getAsString()).intValue();
    }

    @Override
    public Point getElementPosition(ElementLocator elementLocator) {
        return new Point(this.getElementPositionLeft(elementLocator), this.getElementPositionTop(elementLocator));
    }

    @Override
    public int getElementPositionLeft(ElementLocator elementLocator) {
        return this.selenium.getElementPositionLeft(elementLocator.getAsString()).intValue();
    }

    @Override
    public int getElementPositionTop(ElementLocator elementLocator) {
        return this.selenium.getElementPositionTop(elementLocator.getAsString()).intValue();
    }

    @Override
    public int getElementWidth(ElementLocator elementLocator) {
        return this.selenium.getElementWidth(elementLocator.getAsString()).intValue();
    }

    @Override
    public String getEval(JavaScript script) {
        return this.selenium.getEval(script.toString());
    }

    @Override
    public JavaScript getExpression(JavaScript expression) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public String getHtmlSource() {
        return this.selenium.getHtmlSource();
    }

    @Override
    public URL getLocation() {
        try {
            return new URL(this.selenium.getLocation());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getMouseSpeed() {
        return this.selenium.getMouseSpeed().intValue();
    }

    @Override
    public String getPrompt() {
        return this.selenium.getPrompt();
    }

    @Override
    public List<String> getSelectOptions(ElementLocator selectLocator) {
        return Arrays.asList(this.selenium.getSelectOptions(selectLocator.getAsString()));
    }

    @Override
    public String getSelectedId(ElementLocator selectLocator) {
        return this.selenium.getSelectedId(selectLocator.getAsString());
    }

    @Override
    public List<String> getSelectedIds(ElementLocator selectLocator) {
        return Arrays.asList(this.selenium.getSelectedIds(selectLocator.getAsString()));
    }

    @Override
    public int getSelectedIndex(ElementLocator selectLocator) {
        return Integer.valueOf(this.selenium.getSelectedIndex(selectLocator.getAsString()));
    }

    @Override
    public List<Integer> getSelectedIndexes(ElementLocator selectLocator) {
        return Arrays.asList(this.transformArrayOfStringToInteger.transform((String[])this.selenium.getSelectedIndexes(selectLocator.getAsString())));
    }

    @Override
    public String getSelectedLabel(ElementLocator selectLocator) {
        return this.selenium.getSelectedLabel(selectLocator.getAsString());
    }

    @Override
    public List<String> getSelectedLabels(ElementLocator selectLocator) {
        return Arrays.asList(this.selenium.getSelectedLabels(selectLocator.getAsString()));
    }

    @Override
    public String getSelectedValue(ElementLocator selectLocator) {
        return this.selenium.getSelectedValue(this.selenium.getSelectedValue(selectLocator.getAsString()));
    }

    @Override
    public List<String> getSelectedValues(ElementLocator selectLocator) {
        return Arrays.asList(this.selenium.getSelectedValues(selectLocator.getAsString()));
    }

    @Override
    public long getSpeed() {
        return Long.valueOf(this.selenium.getSpeed());
    }

    @Override
    public String getText(ElementLocator elementLocator) {
        return this.selenium.getText(elementLocator.getAsString());
    }

    @Override
    public String getTitle() {
        return this.selenium.getTitle();
    }

    @Override
    public String getValue(ElementLocator elementLocator) {
        return this.selenium.getValue(elementLocator.getAsString());
    }

    @Override
    public boolean getWhetherThisFrameMatchFrameExpression(Frame currentFrame, Frame targetFrame) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public boolean getWhetherThisWindowMatchWindowExpression(Window currentWindowString, Window target) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public void goBack() {
        this.selenium.goBack();
    }

    @Override
    public void highlight(ElementLocator elementLocator) {
        this.selenium.highlight(elementLocator.getAsString());
    }

    @Override
    public void ignoreAttributesWithoutValue(boolean ignore) {
        this.selenium.ignoreAttributesWithoutValue(String.valueOf(ignore));
    }

    @Override
    public boolean isAlertPresent() {
        return this.selenium.isAlertPresent();
    }

    @Override
    public boolean isChecked(ElementLocator elementLocator) {
        return this.selenium.isChecked(elementLocator.getAsString());
    }

    @Override
    public boolean isConfirmationPresent() {
        return this.selenium.isConfirmationPresent();
    }

    @Override
    public boolean isCookiePresent(Cookie name) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public boolean isEditable(ElementLocator elementLocator) {
        return this.selenium.isEditable(elementLocator.getAsString());
    }

    @Override
    public boolean isElementPresent(ElementLocator elementLocator) {
        return this.selenium.isElementPresent(elementLocator.getAsString());
    }

    @Override
    public boolean isOrdered(ElementLocator elementLocator1, ElementLocator elementLocator2) {
        return this.selenium.isOrdered(elementLocator1.getAsString(), elementLocator2.getAsString());
    }

    @Override
    public boolean isPromptPresent() {
        return this.selenium.isPromptPresent();
    }

    @Override
    public boolean isSomethingSelected(ElementLocator selectLocator) {
        return this.selenium.isSomethingSelected(selectLocator.getAsString());
    }

    @Override
    public boolean isTextPresent(String text) {
        return this.selenium.isTextPresent(text);
    }

    @Override
    public boolean isVisible(ElementLocator elementLocator) {
        return this.selenium.isVisible(elementLocator.getAsString());
    }

    @Override
    public void keyDown(ElementLocator elementLocator, String keySequence) {
        this.selenium.keyDown(elementLocator.getAsString(), keySequence);
    }

    @Override
    public void keyDownNative(String keycode) {
        this.selenium.keyDownNative(keycode);
    }

    @Override
    public void keyPress(ElementLocator elementLocator, String keySequence) {
        this.selenium.keyPress(elementLocator.getAsString(), keySequence);
    }

    @Override
    public void keyPressNative(String keycode) {
        this.selenium.keyPressNative(keycode);
    }

    @Override
    public void keyUp(ElementLocator elementLocator, String keySequence) {
        this.selenium.keyUp(elementLocator.getAsString(), keySequence);
    }

    @Override
    public void keyUpNative(String keycode) {
        this.selenium.keyUpNative(keycode);
    }

    @Override
    public void logToBrowser(String textToLog) {
        this.selenium.setContext(textToLog);
    }

    @Override
    public void metaKeyDown() {
        this.selenium.metaKeyDown();
    }

    @Override
    public void metaKeyUp() {
        this.selenium.metaKeyUp();
    }

    @Override
    public void mouseDown(ElementLocator elementLocator) {
        this.selenium.mouseDown(elementLocator.getAsString());
    }

    @Override
    public void mouseDownAt(ElementLocator elementLocator, Point point) {
        this.selenium.mouseDownAt(elementLocator.getAsString(), point.getCoords());
    }

    @Override
    public void mouseDownRight(ElementLocator elementLocator) {
        this.selenium.mouseDownRight(elementLocator.getAsString());
    }

    @Override
    public void mouseDownRightAt(ElementLocator elementLocator, Point point) {
        this.selenium.mouseDownRightAt(elementLocator.getAsString(), point.getCoords());
    }

    @Override
    public void mouseMove(ElementLocator elementLocator) {
        this.selenium.mouseMove(elementLocator.getAsString());
    }

    @Override
    public void mouseMoveAt(ElementLocator elementLocator, Point point) {
        this.selenium.mouseMoveAt(elementLocator.getAsString(), point.getCoords());
    }

    @Override
    public void mouseOut(ElementLocator elementLocator) {
        this.selenium.mouseOut(elementLocator.getAsString());
    }

    @Override
    public void mouseOver(ElementLocator elementLocator) {
        this.selenium.mouseOver(elementLocator.getAsString());
    }

    @Override
    public void mouseUp(ElementLocator elementLocator) {
        this.selenium.mouseUp(elementLocator.getAsString());
    }

    @Override
    public void mouseUpAt(ElementLocator elementLocator, Point point) {
        this.selenium.mouseUpAt(elementLocator.getAsString(), point.getCoords());
    }

    @Override
    public void mouseUpRight(ElementLocator elementLocator) {
        this.selenium.mouseUpRight(elementLocator.getAsString());
    }

    @Override
    public void mouseUpRightAt(ElementLocator elementLocator, Point point) {
        this.selenium.mouseUpRightAt(elementLocator.getAsString(), point.getCoords());
    }

    @Override
    public void open(URL url) {
        this.selenium.open(url.toString());
    }

    @Override
    public void openWindow(URL url, WindowId windowID) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public void refresh() {
        this.selenium.refresh();
    }

    @Override
    public void removeAllSelections(ElementLocator elementLocator) {
        this.selenium.removeAllSelections(elementLocator.getAsString());
    }

    @Override
    public void removeScript(JavaScript javaScript) {
        this.selenium.removeScript(javaScript.getIdentification());
    }

    @Override
    public void removeSelection(ElementLocator elementLocator, ElementLocator optionLocator) {
        this.selenium.removeSelection(elementLocator.getAsString(), optionLocator.getAsString());
    }

    @Override
    public String retrieveLastRemoteControlLogs() {
        return this.selenium.retrieveLastRemoteControlLogs();
    }

    @Override
    public void runScript(JavaScript script) {
        this.selenium.runScript(script.getAsString());
    }

    @Override
    public void select(ElementLocator selectLocator, ElementLocator optionLocator) {
        this.selenium.select(selectLocator.getAsString(), optionLocator.getAsString());
    }

    @Override
    public void selectFrame(FrameLocator frameLocator) {
        this.selenium.selectFrame(frameLocator.getAsString());
    }

    @Override
    public void selectPopUp(WindowId windowID) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public void selectWindow(WindowId windowID) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public void setBrowserLogLevel(LogLevel logLevel) {
        this.selenium.setBrowserLogLevel(logLevel.getLogLevelName());
    }

    @Override
    public void setCursorPosition(ElementLocator elementLocator, int position) {
        this.selenium.setCursorPosition(elementLocator.getAsString(), String.valueOf(position));
    }

    @Override
    public void setExtensionJs(JavaScript extensionJs) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public void setMouseSpeed(int pixels) {
        this.selenium.setMouseSpeed(String.valueOf(pixels));
    }

    @Override
    public void setSpeed(long speedInMilis) {
        this.selenium.setSpeed(String.valueOf(speedInMilis));
    }

    @Override
    public void setTimeout(long timeoutInMilis) {
        this.selenium.setTimeout(String.valueOf(timeoutInMilis));
    }

    @Override
    public void shiftKeyDown() {
        this.selenium.shiftKeyDown();
    }

    @Override
    public void shiftKeyUp() {
        this.selenium.shiftKeyUp();
    }

    @Override
    public void shutDownSeleniumServer() {
        this.selenium.shutDownSeleniumServer();
    }

    @Override
    public void start() {
        this.selenium.start();
    }

    @Override
    public void stop() {
        this.selenium.stop();
    }

    @Override
    public void submit(ElementLocator formLocator) {
        this.selenium.submit(formLocator.getAsString());
    }

    @Override
    public void type(ElementLocator elementLocator, String value) {
        this.selenium.type(elementLocator.getAsString(), value);
    }

    @Override
    public void typeKeys(ElementLocator elementLocator, String value) {
        this.selenium.type(elementLocator.getAsString(), value);
    }

    @Override
    public void uncheck(ElementLocator elementLocator) {
        this.selenium.uncheck(elementLocator.getAsString());
    }

    @Override
    public void useXpathLibrary(XpathLibrary xpathLibrary) {
        this.selenium.useXpathLibrary(xpathLibrary.getXpathLibraryName());
    }

    @Override
    public void waitForCondition(JavaScript script) {
        String timeout = String.valueOf(SystemProperties.getSeleniumTimeout(SystemProperties.SeleniumTimeoutType.DEFAULT));
        this.selenium.waitForCondition(script.getAsString(), timeout);
    }

    @Override
    public void waitForCondition(JavaScript script, long timeout) {
        this.selenium.waitForCondition(script.getAsString(), String.valueOf(timeout));
    }

    @Override
    public void waitForFrameToLoad(URL frameURL) {
        String timeout = String.valueOf(SystemProperties.getSeleniumTimeout(SystemProperties.SeleniumTimeoutType.DEFAULT));
        this.selenium.waitForFrameToLoad(frameURL.toString(), timeout);
    }

    @Override
    public void waitForFrameToLoad(URL frameURL, long timeout) {
        this.selenium.waitForFrameToLoad(frameURL.toString(), String.valueOf(timeout));
    }

    @Override
    public void waitForPageToLoad() {
        String timeout = String.valueOf(SystemProperties.getSeleniumTimeout(SystemProperties.SeleniumTimeoutType.DEFAULT));
        this.selenium.waitForPageToLoad(timeout);
    }

    @Override
    public void waitForPageToLoad(long timeout) {
        this.selenium.waitForPageToLoad(String.valueOf(timeout));
    }

    @Override
    public void waitForPopUp(WindowId windowId, long timeoutInMilis) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public void windowFocus() {
        this.selenium.windowFocus();
    }

    @Override
    public void windowMaximize() {
        this.selenium.windowMaximize();
    }
}

