/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.listener;

import org.jboss.test.selenium.utils.testng.TestLoggingUtils;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class ConsoleStatusTestListener
extends TestListenerAdapter {
    public void onTestStart(ITestResult result) {
        this.logStatus(result, true);
    }

    public void onTestFailure(ITestResult result) {
        this.logStatus(result, false);
    }

    public void onTestSkipped(ITestResult result) {
        this.logStatus(result, false);
    }

    public void onTestSuccess(ITestResult result) {
        this.logStatus(result, false);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.logStatus(result, false);
    }

    private void logStatus(ITestResult result, boolean isTestStart) {
        String message = TestLoggingUtils.getTestDescription(result, isTestStart);
        System.out.println(message);
        if (!isTestStart) {
            System.out.println();
        }
    }
}

