/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.listener;

import org.apache.commons.lang.StringUtils;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.utils.testng.TestLoggingUtils;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class SeleniumLoggingTestListener
extends TestListenerAdapter {
    private AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();

    public void onTestStart(ITestResult result) {
        this.logStatus(result, true);
    }

    public void onTestFailure(ITestResult result) {
        this.logStatus(result, false);
    }

    public void onTestSkipped(ITestResult result) {
        this.logStatus(result, false);
    }

    public void onTestSuccess(ITestResult result) {
        this.logStatus(result, false);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.logStatus(result, false);
    }

    private void logStatus(ITestResult result, boolean isTestStart) {
        String hashes = "##########";
        String testDescription = TestLoggingUtils.getTestDescription(result, isTestStart);
        String message = String.format("%s %s %s", "##########", testDescription, "##########");
        String line = StringUtils.repeat((String)"#", (int)message.length());
        if (this.selenium != null) {
            String output = String.format("\n%s\n%s\n%s\n", line, message, line);
            this.selenium.logToBrowser(output);
        }
    }
}

