/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.request;

import org.jboss.test.selenium.SystemProperties;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.request.RequestType;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;

public class RequestInterceptor {
    private final JavaScript clearRequestDone = JavaScript.js("(getRFS() === undefined) ? 'HTTP' : getRFS().clearRequestDone()");
    private final JavaScript getRequestDone = JavaScript.js("(getRFS() === undefined) ? 'HTTP' : getRFS().getRequestDone()");
    private final JavaScript waitRequestChange = JavaScript.js("((getRFS() === undefined) ? 'HTTP' : getRFS().getRequestDone()) != 'NONE' && selenium.browserbot.getCurrentWindow().document.body");
    private AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();

    public RequestType getRequestTypeDone() {
        String requestDone = this.selenium.getEval(this.getRequestDone);
        return this.parseRequest(requestDone);
    }

    public RequestType clearRequestTypeDone() {
        String lastRequest = this.selenium.getEval(this.clearRequestDone);
        return this.parseRequest(lastRequest);
    }

    public void waitForRequestTypeChange() {
        this.selenium.waitForCondition(this.waitRequestChange, SystemProperties.getSeleniumTimeout(SystemProperties.SeleniumTimeoutType.AJAX));
    }

    private RequestType parseRequest(String request) {
        try {
            return RequestType.valueOf(request);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(SimplifiedFormat.format("Request was evaluated to unknown type '{0}'", request));
        }
    }
}

