/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.utils;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;

public final class ColorUtils {
    private static final int HEX_RADIX = 16;
    private static final int RGB_PARTS = 3;
    private static final short RED_COMPONENT = 0;
    private static final short GREEN_COMPONENT = 1;
    private static final short BLUE_COMPONENT = 2;

    private ColorUtils() {
    }

    public static int convertToInteger(String colorValue) {
        Validate.notNull((Object)colorValue);
        int result = 0;
        if (colorValue.charAt(0) == '#') {
            result = Integer.parseInt(colorValue.substring(1), 16);
        } else {
            Matcher matcher = Pattern.compile("(\\d+)").matcher(colorValue);
            int[] array = new int[3];
            for (int i = 0; i < 3; ++i) {
                if (!matcher.find()) {
                    throw new IllegalArgumentException(colorValue);
                }
                array[i] = Short.parseShort(matcher.group(1));
            }
            result = new Color(array[0], array[1], array[2]).getRGB();
        }
        return result;
    }

    public static Color convertToAWTColor(String colorValue) {
        if (colorValue == null) {
            return null;
        }
        int convertedValue = ColorUtils.convertToInteger(colorValue);
        return new Color(convertedValue);
    }
}

