/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium;

import java.io.File;
import java.net.URL;
import org.apache.commons.lang.Validate;
import org.jboss.test.selenium.browser.Browser;
import org.jboss.test.selenium.utils.PrimitiveUtils;
import org.jboss.test.selenium.utils.URLUtils;

public final class SystemProperties {
    private SystemProperties() {
    }

    public static URL getContextRoot() {
        String contextRoot = System.getProperty("context.root");
        Validate.notNull((Object)contextRoot, (String)"context.root system property should be set");
        return URLUtils.buildUrl(contextRoot, new String[0]);
    }

    public static URL getContextPath() {
        String contextPath = System.getProperty("context.path");
        Validate.notNull((Object)contextPath, (String)"context.path system property should be set");
        return URLUtils.buildUrl(SystemProperties.getContextRoot(), contextPath);
    }

    public static Browser getBrowser() {
        String browser = System.getProperty("browser");
        Validate.notNull((Object)browser, (String)"browser system property should be set");
        return new Browser(browser);
    }

    public static File getMavenResourcesDir() {
        return new File(System.getProperty("maven.resources.dir", "./target/test-classes/"));
    }

    public static File getMavenProjectBuildDirectory() {
        return new File(System.getProperty("maven.project.build.directory", "./target/"));
    }

    public static String getSeleniumHost() {
        String seleniumHost = System.getProperty("selenium.host", "localhost");
        Validate.notNull((Object)seleniumHost, (String)"selenium.host system property should be set");
        return seleniumHost;
    }

    public static int getSeleniumPort() {
        String seleniumPort = System.getProperty("selenium.port");
        Validate.notNull((Object)seleniumPort, (String)"selenium.port system property should be set");
        return PrimitiveUtils.asInteger(seleniumPort);
    }

    public static boolean isSeleniumMaximize() {
        return PrimitiveUtils.asBoolean(System.getProperty("selenium.maximize", "false"));
    }

    public static boolean isSeleniumDebug() {
        return PrimitiveUtils.asBoolean(System.getProperty("selenium.debug", "false"));
    }

    public static int getSeleniumSpeed() {
        return PrimitiveUtils.asInteger(System.getProperty("selenium.speed", "0"));
    }

    public static boolean isSeleniumNetworkTrafficEnabled() {
        return PrimitiveUtils.asBoolean(System.getProperty("selenium.network.traffic", "false"));
    }

    public static long getSeleniumTimeout(SeleniumTimeoutType type) {
        Validate.notNull((Object)((Object)type));
        String seleniumTimeout = System.getProperty("selenium.timeout." + type.toString().toLowerCase());
        if (seleniumTimeout == null) {
            return type.defaultTimeout;
        }
        return PrimitiveUtils.asLong(seleniumTimeout);
    }

    public static enum SeleniumTimeoutType {
        DEFAULT(30000),
        GUI(5000),
        AJAX(15000),
        MODEL(30000);

        int defaultTimeout;

        private SeleniumTimeoutType(int defaultTimeout) {
            this.defaultTimeout = defaultTimeout;
        }
    }
}

