/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.framework.internal;

import java.util.List;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;

public class PageExtensions {
    JavaScript pageExtensions;
    final JavaScript isBodyLoaded = JavaScript.js("(selenium.browserbot.getCurrentWindow() != null)  && (selenium.browserbot.getCurrentWindow().document != null)  && (selenium.browserbot.getCurrentWindow().document.body != null)");
    final JavaScript isRFSUndefined = JavaScript.js("getRFS() === undefined");
    AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();

    public void install() {
        if (!this.isInstalled()) {
            this.waitForBodyLoaded();
            this.installPageExtension();
        }
    }

    public boolean isInstalled() {
        return Boolean.valueOf(this.selenium.getEval(this.isRFSUndefined)) == false;
    }

    void installPageExtension() {
        this.selenium.runScript(this.pageExtensions);
    }

    void waitForBodyLoaded() {
        this.selenium.waitForCondition(this.isBodyLoaded, 30000L);
    }

    public void loadFromResources(List<String> resourceNames) {
        JavaScript extensions = null;
        for (String resourceName : resourceNames) {
            JavaScript partial = JavaScript.fromResource(resourceName);
            extensions = extensions == null ? partial : extensions.join(partial);
        }
        this.pageExtensions = extensions;
    }
}

