/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.waiting.retrievers;

import org.apache.commons.lang.Validate;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.locator.AttributeLocator;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;
import org.jboss.test.selenium.waiting.conversion.Convertor;
import org.jboss.test.selenium.waiting.conversion.PassOnConvertor;
import org.jboss.test.selenium.waiting.retrievers.AbstractRetriever;
import org.jboss.test.selenium.waiting.retrievers.Retriever;

public class AttributeRetriever
extends AbstractRetriever<String>
implements Retriever<String> {
    private AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();
    private AttributeLocator<?> attributeLocator;

    protected AttributeRetriever() {
    }

    @Override
    public String retrieve() {
        Validate.notNull(this.attributeLocator);
        return this.selenium.getAttribute(this.attributeLocator);
    }

    @Override
    public JavaScript getJavaScriptRetrieve() {
        return JavaScript.js(SimplifiedFormat.format("selenium.getAttribute('{0}')", this.attributeLocator.getAsString()));
    }

    public static AttributeRetriever getInstance() {
        return new AttributeRetriever();
    }

    public AttributeRetriever attributeLocator(AttributeLocator<?> attributeLocator) {
        Validate.notNull(attributeLocator);
        AttributeRetriever copy = this.copy();
        copy.attributeLocator = attributeLocator;
        return copy;
    }

    private AttributeRetriever copy() {
        AttributeRetriever copy = new AttributeRetriever();
        copy.attributeLocator = this.attributeLocator;
        return copy;
    }

    @Override
    public Convertor<String, String> getConvertor() {
        return new PassOnConvertor<String>();
    }
}

