/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.threads.metadata;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "bounded-ordered-executor")
public final class BoundedOrderedExecutorMetaData {
    private String name;
    private boolean blocking;
    private RefMetaData parentExecutor;
    private ScaledCountMetaData queueLength;
    private RefMetaData handoffExecutor;

    public String getName() {
        return name;
    }

    @XmlAttribute(required = true)
    public void setName(final String name) {
        this.name = name;
    }

    public boolean isBlocking() {
        return blocking;
    }

    @XmlAttribute
    public void setBlocking(final boolean blocking) {
        this.blocking = blocking;
    }

    public RefMetaData getParentExecutor() {
        return parentExecutor;
    }

    @XmlElement(name = "parent-executor", required = true)
    public void setParentExecutor(final RefMetaData parentExecutor) {
        this.parentExecutor = parentExecutor;
    }

    public ScaledCountMetaData getQueueLength() {
        return queueLength;
    }

    @XmlElement(name = "queue-length", required = true)
    public void setQueueLength(final ScaledCountMetaData queueLength) {
        this.queueLength = queueLength;
    }

    public RefMetaData getHandoffExecutor() {
        return handoffExecutor;
    }

    @XmlElement(name = "handoff-executor")
    public void setHandoffExecutor(final RefMetaData handoffExecutor) {
        this.handoffExecutor = handoffExecutor;
    }
}
