/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads.metadata;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.logging.Logger;
import org.jboss.threads.ArrayQueue;
import org.jboss.threads.DirectExecutor;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.JBossThreadFactory;
import org.jboss.threads.JBossThreadPoolExecutor;
import org.jboss.threads.OrderedExecutor;
import org.jboss.threads.QueueExecutor;
import org.jboss.threads.QueuelessExecutor;
import org.jboss.threads.management.BoundedQueueThreadPoolExecutorMBean;
import org.jboss.threads.management.BoundedThreadPoolExecutorMBean;
import org.jboss.threads.management.ThreadExecutorMBean;
import org.jboss.threads.management.ThreadPoolExecutorMBean;
import org.jboss.threads.metadata.AbstractTaskFilter;
import org.jboss.threads.metadata.BoundedOrderedExecutorMetaData;
import org.jboss.threads.metadata.BoundedQueueThreadPoolExecutorMetaData;
import org.jboss.threads.metadata.DirectExecutorMetaData;
import org.jboss.threads.metadata.QueuelessThreadPoolExecutorMetaData;
import org.jboss.threads.metadata.RefMetaData;
import org.jboss.threads.metadata.ScaledCountMetaData;
import org.jboss.threads.metadata.ScheduledThreadPoolExecutorMetaData;
import org.jboss.threads.metadata.TaskFilterMetaData;
import org.jboss.threads.metadata.ThreadFactoryExecutorMetaData;
import org.jboss.threads.metadata.ThreadFactoryMetaData;
import org.jboss.threads.metadata.ThreadGroupMetaData;
import org.jboss.threads.metadata.ThreadMetaData;
import org.jboss.threads.metadata.TimeMetaData;
import org.jboss.threads.metadata.UnboundedOrderedExecutorMetaData;
import org.jboss.threads.metadata.UnboundedQueueThreadPoolExecutorMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadsHelper {
    static final Map<String, String> UNIT_NICK_NAMES = ThreadsHelper.stringMap(ThreadsHelper.entry("S", "SECONDS"), ThreadsHelper.entry("SEC", "SECONDS"), ThreadsHelper.entry("SECOND", "SECONDS"), ThreadsHelper.entry("SECONDS", "SECONDS"), ThreadsHelper.entry("M", "MINUTES"), ThreadsHelper.entry("MIN", "MINUTES"), ThreadsHelper.entry("MINUTE", "MINUTES"), ThreadsHelper.entry("MINUTES", "MINUTES"), ThreadsHelper.entry("MS", "MILLISECONDS"), ThreadsHelper.entry("MILLIS", "MILLISECONDS"), ThreadsHelper.entry("MILLISECOND", "MILLISECONDS"), ThreadsHelper.entry("MILLISECONDS", "MILLISECONDS"), ThreadsHelper.entry("NS", "NANOSECONDS"), ThreadsHelper.entry("NANOS", "NANOSECONDS"), ThreadsHelper.entry("NANOSECOND", "NANOSECONDS"), ThreadsHelper.entry("NANOSECONDS", "NANOSECONDS"), ThreadsHelper.entry("H", "HOURS"), ThreadsHelper.entry("HOUR", "HOURS"), ThreadsHelper.entry("HOURS", "HOURS"), ThreadsHelper.entry("D", "DAYS"), ThreadsHelper.entry("DAY", "DAYS"), ThreadsHelper.entry("DAYS", "DAYS"), ThreadsHelper.entry("MON", "MONTHS"), ThreadsHelper.entry("MONTH", "MONTHS"), ThreadsHelper.entry("MONTHS", "MONTHS"), ThreadsHelper.entry("W", "WEEKS"), ThreadsHelper.entry("WEEK", "WEEKS"), ThreadsHelper.entry("WEEKS", "WEEKS"));

    private ThreadsHelper() {
    }

    public static Runnable createTaskFilterTask(List<Object> objects, Runnable task) {
        return JBossExecutors.executorTask((DirectExecutor)ThreadsHelper.createTaskFilter(objects), (Runnable)task);
    }

    public static DirectExecutor createTaskFilter(List<Object> objects) {
        return ThreadsHelper.createTaskFilterRecursive(objects.iterator());
    }

    static DirectExecutor createTaskFilterRecursive(Iterator<Object> it) {
        if (!it.hasNext()) {
            return JBossExecutors.directExecutor();
        }
        Object object = it.next();
        if (object instanceof DirectExecutor && !it.hasNext()) {
            return (DirectExecutor)object;
        }
        switch ((FilterTypes)((Object)object)) {
            case THREAD_NAME: {
                String nextString = (String)it.next();
                return JBossExecutors.threadNameExecutor((DirectExecutor)ThreadsHelper.createTaskFilterRecursive(it), (String)nextString);
            }
            case THREAD_NAME_NOTATION: {
                String nextString = (String)it.next();
                return JBossExecutors.threadNameNotateExecutor((DirectExecutor)ThreadsHelper.createTaskFilterRecursive(it), (String)nextString);
            }
            case LOG_EXCEPTIONS: {
                Logger log = Logger.getLogger((String)((String)it.next()));
                Logger.Level level = Logger.Level.valueOf((String)((String)it.next()));
                return JBossExecutors.exceptionLoggingExecutor((DirectExecutor)ThreadsHelper.createTaskFilterRecursive(it), (Logger)log, (Logger.Level)level);
            }
            case CLEAR_TLS: {
                return JBossExecutors.resettingExecutor((DirectExecutor)ThreadsHelper.createTaskFilterRecursive(it));
            }
            case CLEAR_CONTEXT_CLASSLOADER: {
                return JBossExecutors.cleanupExecutor((DirectExecutor)ThreadsHelper.createTaskFilterRecursive(it), (Runnable)JBossExecutors.contextClassLoaderResetter());
            }
            case INITIALIZER: {
                Runnable r = (Runnable)it.next();
                return JBossExecutors.initializingExecutor((DirectExecutor)ThreadsHelper.createTaskFilterRecursive(it), (Runnable)r);
            }
            case CLEANER: {
                Runnable r = (Runnable)it.next();
                return JBossExecutors.cleanupExecutor((DirectExecutor)ThreadsHelper.createTaskFilterRecursive(it), (Runnable)r);
            }
        }
        throw new IllegalStateException();
    }

    public static Thread createThread(ThreadFactory threadFactory, List<Object> taskFilterObjects, Runnable task) {
        return threadFactory.newThread(ThreadsHelper.createTaskFilterTask(taskFilterObjects, task));
    }

    public static ThreadFactory createThreadFactory(ThreadGroup threadGroup, Boolean daemon, Integer priority, String namePattern, Thread.UncaughtExceptionHandler exceptionHandler, Long stackSize, List<Object> taskFilterObjects) {
        return JBossExecutors.wrappingThreadFactory((DirectExecutor)ThreadsHelper.createTaskFilter(taskFilterObjects), (ThreadFactory)new JBossThreadFactory(threadGroup, daemon, priority, namePattern, exceptionHandler, stackSize));
    }

    public static Executor createJBossThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, List<Object> taskFilterObjects) {
        return JBossExecutors.wrappingExecutor((DirectExecutor)ThreadsHelper.createTaskFilter(taskFilterObjects), (Executor)new JBossThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory));
    }

    public static Executor createThreadFactoryExecutor(ThreadFactory factory, int maxThreads, boolean blocking, List<Object> taskFilterObjects) {
        return JBossExecutors.threadFactoryExecutor((ThreadFactory)factory, (int)maxThreads, (boolean)blocking, (DirectExecutor)ThreadsHelper.createTaskFilter(taskFilterObjects));
    }

    public static QueueExecutor createQueueExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, Queue<Runnable> queue, ThreadFactory threadFactory, boolean blocking, Executor handoffExecutor, List<Object> taskFilterObjects) {
        return new QueueExecutor(corePoolSize, maxPoolSize, keepAliveTime, keepAliveTimeUnit, queue, threadFactory, blocking, handoffExecutor, ThreadsHelper.createTaskFilter(taskFilterObjects));
    }

    public static QueuelessExecutor createQueuelessExecutor(ThreadFactory threadFactory, List<Object> taskFilterObjects, Executor handoffExecutor, long idleTimeout) {
        return new QueuelessExecutor(threadFactory, ThreadsHelper.createTaskFilter(taskFilterObjects), handoffExecutor, idleTimeout);
    }

    static int calculateScaledCount(ScaledCountMetaData poolSizeMetaData) {
        float count = poolSizeMetaData.getCount();
        float perCpu = poolSizeMetaData.getPerCpu();
        if (Float.isNaN(count) || Float.isInfinite(count) || count < 0.0f) {
            count = 0.0f;
        }
        if (Float.isNaN(perCpu) || Float.isInfinite(perCpu) || perCpu < 0.0f) {
            perCpu = 0.0f;
        }
        return Math.round(count + (float)Runtime.getRuntime().availableProcessors() * perCpu);
    }

    private static StringEntry entry(String key, String value) {
        return new StringEntry(key, value);
    }

    private static Map<String, String> stringMap(StringEntry ... entries) {
        HashMap hashMap = new HashMap(entries.length);
        for (StringEntry e : entries) {
            hashMap.put(e.getKey(), e.getValue());
        }
        return Collections.unmodifiableMap(hashMap);
    }

    static void addMetaData(List<BeanMetaData> beanMetaDataList, ThreadMetaData metaData) {
        RefMetaData exceptionHandler;
        Integer priority;
        String name = metaData.getName();
        RefMetaData threadFactoryRef = metaData.getThreadFactory();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)Thread.class.getName());
        TaskFilterMetaData taskFilter = metaData.getTaskFilter();
        if (taskFilter != null) {
            builder.setFactoryClass(ThreadsHelper.class.getName());
            builder.setFactoryMethod("createThread");
            builder.addConstructorParameter(ThreadFactory.class.getName(), builder.createInject((Object)threadFactoryRef.getName()));
            List objectList = builder.createList(ArrayList.class.getName(), Object.class.getName());
            for (AbstractTaskFilter filter : taskFilter.getTaskFilters()) {
                filter.addTo(builder, objectList);
            }
            builder.addConstructorParameter(List.class.getName(), (ValueMetaData)objectList);
            builder.addConstructorParameter(Runnable.class.getName(), builder.createInject((Object)metaData.getTask().getName()));
        } else {
            builder.setFactory(builder.createInject((Object)threadFactoryRef.getName()));
            builder.addConstructorParameter(Runnable.class.getName(), builder.createInject((Object)metaData.getTask().getName()));
        }
        Boolean daemon = metaData.isDaemon();
        if (daemon != null) {
            builder.addPropertyMetaData("daemon", (Object)daemon);
        }
        if ((priority = metaData.getPriority()) != null) {
            builder.addPropertyMetaData("priority", (Object)priority);
        }
        if ((exceptionHandler = metaData.getExceptionHandler()) != null) {
            builder.addPropertyMetaData("uncaughtExceptionHandler", builder.createInject((Object)exceptionHandler.getName()));
        }
        builder.ignoreCreate();
        builder.setStop("interrupt");
        builder.ignoreDestroy();
        beanMetaDataList.add(builder.getBeanMetaData());
    }

    static void addMetaData(List<BeanMetaData> beanMetaDataList, ThreadGroupMetaData metaData) {
        Integer maxPriorityMeta;
        String name = metaData.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)ThreadGroup.class.getName());
        RefMetaData parentRef = metaData.getParentThreadGroup();
        if (parentRef != null) {
            builder.addConstructorParameter(ThreadGroup.class.getName(), builder.createInject((Object)parentRef.getName()));
        }
        String groupName = metaData.getGroupName();
        builder.addConstructorParameter(String.class.getName(), builder.createValue((Object)(groupName != null ? groupName : name)));
        if (metaData.isDaemon() != null) {
            builder.addPropertyMetaData("daemon", builder.createValue((Object)metaData.isDaemon()));
        }
        if ((maxPriorityMeta = metaData.getMaxPriority()) != null) {
            builder.addPropertyMetaData("maxPriority", builder.createValue((Object)maxPriorityMeta));
        }
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.setStop("interrupt");
        builder.ignoreDestroy();
        beanMetaDataList.add(builder.getBeanMetaData());
    }

    static void addMetaData(List<BeanMetaData> beanMetaDataList, ThreadFactoryMetaData metaData) {
        String name = metaData.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)JBossThreadFactory.class.getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.ignoreDestroy();
        RefMetaData groupRef = metaData.getThreadGroup();
        builder.addConstructorParameter(ThreadGroup.class.getName(), groupRef == null ? builder.createNull() : builder.createInject((Object)groupRef.getName()));
        Boolean daemon = metaData.getDaemon();
        builder.addConstructorParameter(Boolean.class.getName(), daemon == null ? builder.createNull() : builder.createValue((Object)daemon));
        Integer priorityMeta = metaData.getPriority();
        Integer actualPriorityMeta = priorityMeta != null ? priorityMeta : null;
        builder.addConstructorParameter(Integer.class.getName(), actualPriorityMeta == null ? builder.createNull() : builder.createValue((Object)actualPriorityMeta));
        builder.addConstructorParameter(String.class.getName(), builder.createValue((Object)metaData.getThreadNamePattern()));
        RefMetaData exceptionHandler = metaData.getExceptionHandler();
        builder.addConstructorParameter(Thread.UncaughtExceptionHandler.class.getName(), exceptionHandler == null ? builder.createNull() : builder.createInject((Object)exceptionHandler.getName()));
        builder.addConstructorParameter(Long.class.getName(), builder.createNull());
        TaskFilterMetaData taskFilter = metaData.getTaskFilter();
        if (taskFilter != null) {
            builder.setFactoryClass(ThreadsHelper.class.getName());
            builder.setFactoryMethod("createThreadFactory");
            List list = builder.createList(ArrayList.class.getName(), Object.class.getName());
            for (AbstractTaskFilter filter : taskFilter.getTaskFilters()) {
                filter.addTo(builder, list);
            }
            builder.addConstructorParameter(List.class.getName(), (ValueMetaData)list);
        }
        beanMetaDataList.add(builder.getBeanMetaData());
    }

    static void addMetaData(List<BeanMetaData> beanMetaDataList, ThreadFactoryExecutorMetaData metaData) {
        String name = metaData.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)Executor.class.getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.ignoreDestroy();
        builder.setFactoryClass(JBossExecutors.class.getName());
        builder.setFactoryMethod("threadFactoryExecutor");
        RefMetaData threadFactory = metaData.getThreadFactory();
        if (threadFactory != null) {
            builder.addConstructorParameter(ThreadFactory.class.getName(), builder.createInject((Object)threadFactory.getName()));
        } else {
            builder.addConstructorParameter(ThreadFactory.class.getName(), builder.createValue((Object)Executors.defaultThreadFactory()));
        }
        ScaledCountMetaData maxThreads = metaData.getMaxThreads();
        if (maxThreads != null) {
            builder.addConstructorParameter(Integer.TYPE.getName(), (Object)ThreadsHelper.calculateScaledCount(maxThreads));
        } else {
            builder.addConstructorParameter(Integer.TYPE.getName(), (Object)Integer.MAX_VALUE);
        }
        builder.addConstructorParameter(Boolean.TYPE.getName(), (Object)metaData.isBlocking());
        TaskFilterMetaData taskFilter = metaData.getTaskFilter();
        if (taskFilter != null) {
            builder.setFactoryClass(ThreadsHelper.class.getName());
            builder.setFactoryMethod("createThreadFactoryExecutor");
            List list = builder.createList(ArrayList.class.getName(), Object.class.getName());
            for (AbstractTaskFilter filter : taskFilter.getTaskFilters()) {
                filter.addTo(builder, list);
            }
            builder.addConstructorParameter(List.class.getName(), (ValueMetaData)list);
        }
        builder.addAnnotation((Annotation)((Object)new LiteralJMX(ThreadExecutorMBean.class, "jboss.threads:type=threadFactoryExecutor,name=" + ObjectName.quote(name), false)));
        beanMetaDataList.add(builder.getBeanMetaData());
    }

    static void addMetaData(List<BeanMetaData> beanMetaDataList, UnboundedQueueThreadPoolExecutorMetaData metaData) {
        String name = metaData.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)Executor.class.getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.setStop("shutdown");
        builder.ignoreDestroy();
        int coreThreads = ThreadsHelper.calculateScaledCount(metaData.getMaxThreads());
        builder.addConstructorParameter(Integer.TYPE.getName(), (Object)coreThreads);
        builder.addConstructorParameter(Integer.TYPE.getName(), (Object)coreThreads);
        TimeMetaData keepaliveTime = metaData.getKeepaliveTime();
        if (keepaliveTime != null) {
            builder.addConstructorParameter(Long.TYPE.getName(), (Object)keepaliveTime.getTime());
            builder.addConstructorParameter(TimeUnit.class.getName(), builder.createValue((Object)TimeUnit.valueOf(UNIT_NICK_NAMES.get(keepaliveTime.getUnit().toUpperCase()))));
            builder.addPropertyMetaData("allowCoreThreadTimeout", (Object)Boolean.TRUE);
        } else {
            builder.addConstructorParameter(Long.TYPE.getName(), (Object)Long.MAX_VALUE);
            builder.addConstructorParameter(TimeUnit.class.getName(), builder.createValue((Object)TimeUnit.SECONDS));
        }
        builder.addConstructorParameter(Queue.class.getName(), builder.createValue(new LinkedBlockingQueue()));
        RefMetaData threadFactory = metaData.getThreadFactory();
        if (threadFactory != null) {
            builder.addConstructorParameter(ThreadFactory.class.getName(), builder.createInject((Object)threadFactory.getName()));
        } else {
            builder.addConstructorParameter(ThreadFactory.class.getName(), builder.createValue((Object)Executors.defaultThreadFactory()));
        }
        TaskFilterMetaData taskFilter = metaData.getTaskFilter();
        if (taskFilter != null) {
            builder.setFactoryClass(ThreadsHelper.class.getName());
            builder.setFactoryMethod("createJBossThreadPoolExecutor");
            List list = builder.createList(ArrayList.class.getName(), Object.class.getName());
            for (AbstractTaskFilter filter : taskFilter.getTaskFilters()) {
                filter.addTo(builder, list);
            }
            builder.addConstructorParameter(List.class.getName(), (ValueMetaData)list);
        }
        builder.addAnnotation((Annotation)((Object)new LiteralJMX(ThreadPoolExecutorMBean.class, "jboss.threads:type=unboundedQueueThreadPool,name=" + name, false)));
        beanMetaDataList.add(builder.getBeanMetaData());
    }

    public static void addMetaData(List<BeanMetaData> beanMetaDataList, BoundedQueueThreadPoolExecutorMetaData metaData) {
        TaskFilterMetaData taskFilter;
        String name = metaData.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)QueueExecutor.class.getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.setStop("shutdown");
        builder.ignoreDestroy();
        ScaledCountMetaData coreThreads = metaData.getCoreThreads();
        ScaledCountMetaData maxThreads = metaData.getMaxThreads();
        if (coreThreads != null) {
            builder.addConstructorParameter(Integer.TYPE.getName(), (Object)ThreadsHelper.calculateScaledCount(coreThreads));
        } else {
            builder.addConstructorParameter(Integer.TYPE.getName(), (Object)ThreadsHelper.calculateScaledCount(maxThreads));
        }
        builder.addConstructorParameter(Integer.TYPE.getName(), (Object)ThreadsHelper.calculateScaledCount(maxThreads));
        TimeMetaData keepaliveTime = metaData.getKeepaliveTime();
        if (keepaliveTime != null) {
            builder.addConstructorParameter(Long.TYPE.getName(), (Object)keepaliveTime.getTime());
            builder.addConstructorParameter(TimeUnit.class.getName(), builder.createValue((Object)TimeUnit.valueOf(UNIT_NICK_NAMES.get(keepaliveTime.getUnit().toUpperCase()))));
        } else {
            builder.addConstructorParameter(Long.TYPE.getName(), (Object)Long.MAX_VALUE);
            builder.addConstructorParameter(TimeUnit.class.getName(), builder.createValue((Object)TimeUnit.SECONDS));
        }
        builder.addConstructorParameter(Queue.class.getName(), builder.createValue((Object)new ArrayQueue(ThreadsHelper.calculateScaledCount(metaData.getQueueLength()))));
        RefMetaData threadFactory = metaData.getThreadFactory();
        if (threadFactory != null) {
            builder.addConstructorParameter(ThreadFactory.class.getName(), builder.createInject((Object)threadFactory.getName()));
        }
        builder.addConstructorParameter(Boolean.TYPE.getName(), (Object)metaData.isBlocking());
        RefMetaData handoffExecutor = metaData.getHandoffExecutor();
        if (handoffExecutor != null) {
            builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)handoffExecutor.getName()));
        } else {
            builder.addConstructorParameter(Executor.class.getName(), builder.createNull());
        }
        if (metaData.isAllowCoreTimeout()) {
            builder.addPropertyMetaData("allowCoreTimeout", (Object)Boolean.TRUE);
        }
        if ((taskFilter = metaData.getTaskFilter()) != null) {
            builder.setFactoryClass(ThreadsHelper.class.getName());
            builder.setFactoryMethod("createQueueExecutor");
            List list = builder.createList(ArrayList.class.getName(), Object.class.getName());
            for (AbstractTaskFilter filter : taskFilter.getTaskFilters()) {
                filter.addTo(builder, list);
            }
            builder.addConstructorParameter(List.class.getName(), (ValueMetaData)list);
        }
        builder.addAnnotation((Annotation)((Object)new LiteralJMX(BoundedQueueThreadPoolExecutorMBean.class, "jboss.threads:type=boundedQueueThreadPool,name=" + name, false)));
        beanMetaDataList.add(builder.getBeanMetaData());
    }

    public static void addMetaData(List<BeanMetaData> beanMetaDataList, QueuelessThreadPoolExecutorMetaData metaData) {
        String name = metaData.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)QueuelessExecutor.class.getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.setStop("shutdown");
        builder.ignoreDestroy();
        RefMetaData threadFactory = metaData.getThreadFactory();
        if (threadFactory != null) {
            builder.addConstructorParameter(ThreadFactory.class.getName(), builder.createInject((Object)threadFactory.getName()));
        } else {
            builder.addConstructorParameter(ThreadFactory.class.getName(), builder.createValue((Object)Executors.defaultThreadFactory()));
        }
        TaskFilterMetaData taskFilter = metaData.getTaskFilter();
        if (taskFilter != null) {
            builder.setFactoryClass(ThreadsHelper.class.getName());
            builder.setFactoryMethod("createQueuelessExecutor");
            List list = builder.createList(ArrayList.class.getName(), Object.class.getName());
            for (AbstractTaskFilter filter : taskFilter.getTaskFilters()) {
                filter.addTo(builder, list);
            }
            builder.addConstructorParameter(List.class.getName(), (ValueMetaData)list);
        } else {
            builder.addConstructorParameter(DirectExecutor.class.getName(), builder.createValue((Object)JBossExecutors.directExecutor()));
        }
        RefMetaData handoffExecutor = metaData.getHandoffExecutor();
        if (handoffExecutor != null) {
            builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)handoffExecutor.getName()));
        } else {
            builder.addConstructorParameter(Executor.class.getName(), builder.createNull());
        }
        TimeMetaData keepaliveTime = metaData.getKeepaliveTime();
        if (keepaliveTime != null) {
            TimeUnit unit = TimeUnit.valueOf(UNIT_NICK_NAMES.get(keepaliveTime.getUnit().toUpperCase()));
            builder.addConstructorParameter(Long.TYPE.getName(), builder.createValue((Object)unit.toMillis(keepaliveTime.getTime())));
        } else {
            builder.addConstructorParameter(Long.TYPE.getName(), builder.createValue((Object)Long.MAX_VALUE));
        }
        ScaledCountMetaData maxThreads = metaData.getMaxThreads();
        if (maxThreads != null) {
            builder.addPropertyMetaData("maxThreads", (Object)ThreadsHelper.calculateScaledCount(maxThreads));
        } else {
            builder.addPropertyMetaData("maxThreads", (Object)Integer.MAX_VALUE);
        }
        if (metaData.isBlocking()) {
            builder.addPropertyMetaData("blocking", (Object)Boolean.TRUE);
        }
        builder.addAnnotation((Annotation)((Object)new LiteralJMX(BoundedThreadPoolExecutorMBean.class, "jboss.threads:type=queuelessThreadPool,name=" + name, false)));
        beanMetaDataList.add(builder.getBeanMetaData());
    }

    public static void addMetaData(List<BeanMetaData> beanMetaDataList, ScheduledThreadPoolExecutorMetaData metaData) {
        TaskFilterMetaData taskFilter;
        String name = metaData.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)QueuelessExecutor.class.getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.setStop("shutdown");
        builder.ignoreDestroy();
        ScaledCountMetaData coreThreads = metaData.getMaxThreads();
        builder.addConstructorParameter(Integer.TYPE.getName(), (Object)(coreThreads == null ? Integer.valueOf(1) : Integer.valueOf(ThreadsHelper.calculateScaledCount(coreThreads))));
        RefMetaData threadFactory = metaData.getThreadFactory();
        if (threadFactory != null) {
            builder.addConstructorParameter(ThreadFactory.class.getName(), builder.createInject((Object)threadFactory.getName()));
        } else {
            builder.addConstructorParameter(ThreadFactory.class.getName(), builder.createValue((Object)Executors.defaultThreadFactory()));
        }
        TimeMetaData keepaliveTime = metaData.getKeepaliveTime();
        if (keepaliveTime != null) {
            TimeUnit unit = TimeUnit.valueOf(UNIT_NICK_NAMES.get(keepaliveTime.getUnit().toUpperCase()));
            builder.addPropertyMetaData("keepAliveTime", builder.createValue((Object)unit.toMillis(keepaliveTime.getTime())));
        }
        if ((taskFilter = metaData.getTaskFilter()) != null) {
            throw new UnsupportedOperationException("task-filter not yet supported on scheduled-thread-pool-executor");
        }
        builder.addAnnotation((Annotation)((Object)new LiteralJMX(ThreadPoolExecutorMBean.class, "jboss.threads:type=scheduledThreadPool,name=" + name, false)));
        beanMetaDataList.add(builder.getBeanMetaData());
    }

    public static void addMetaData(List<BeanMetaData> beanMetaDataList, UnboundedOrderedExecutorMetaData metaData) {
        String name = metaData.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)OrderedExecutor.class.getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.ignoreDestroy();
        builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)metaData.getParentExecutor().getName()));
        beanMetaDataList.add(builder.getBeanMetaData());
    }

    public static void addMetaData(List<BeanMetaData> beanMetaDataList, BoundedOrderedExecutorMetaData metaData) {
        String name = metaData.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)OrderedExecutor.class.getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.ignoreDestroy();
        builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)metaData.getParentExecutor().getName()));
        builder.addConstructorParameter(Integer.TYPE.getName(), (Object)ThreadsHelper.calculateScaledCount(metaData.getQueueLength()));
        builder.addConstructorParameter(Boolean.TYPE.getName(), (Object)metaData.isBlocking());
        RefMetaData handoffExecutor = metaData.getHandoffExecutor();
        builder.addConstructorParameter(Executor.class.getName(), handoffExecutor != null ? builder.createInject((Object)handoffExecutor.getName()) : builder.createNull());
        beanMetaDataList.add(builder.getBeanMetaData());
    }

    public static void addMetaData(List<BeanMetaData> beanMetaDataList, DirectExecutorMetaData metaData) {
        String name = metaData.getName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)DirectExecutor.class.getName());
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.ignoreDestroy();
        TaskFilterMetaData taskFilter = metaData.getTaskFilter();
        if (taskFilter != null) {
            builder.setFactoryClass(ThreadsHelper.class.getName());
            builder.setFactoryMethod("createTaskFilter");
            List list = builder.createList(ArrayList.class.getName(), Object.class.getName());
            for (AbstractTaskFilter filter : taskFilter.getTaskFilters()) {
                filter.addTo(builder, list);
            }
            builder.addConstructorParameter(List.class.getName(), (ValueMetaData)list);
        } else {
            builder.setFactoryClass(JBossExecutors.class.getName());
            builder.setFactoryMethod("directExecutor");
        }
        beanMetaDataList.add(builder.getBeanMetaData());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LiteralJMX
    implements JMX {
        private final Class<?> exposedInterface;
        private final String name;
        private final boolean registerDirectly;

        private LiteralJMX(Class<?> exposedInterface, String name, boolean registerDirectly) {
            this.exposedInterface = exposedInterface;
            this.name = name;
            this.registerDirectly = registerDirectly;
        }

        public Class<?> exposedInterface() {
            return this.exposedInterface;
        }

        public String name() {
            return this.name;
        }

        public boolean registerDirectly() {
            return this.registerDirectly;
        }

        public Class<? extends Annotation> annotationType() {
            return JMX.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringEntry
    implements Map.Entry<String, String> {
        private final String key;
        private final String value;

        private StringEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FilterTypes {
        THREAD_NAME,
        THREAD_NAME_NOTATION,
        LOG_EXCEPTIONS,
        CLEAR_TLS,
        CLEAR_CONTEXT_CLASSLOADER,
        INITIALIZER,
        CLEANER;

    }
}

