/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.threads.metadata;

import java.util.List;
import java.util.ArrayList;
import org.jboss.xb.annotations.JBossXmlConstants;
import org.jboss.xb.annotations.JBossXmlModelGroup;
import org.jboss.xb.annotations.JBossXmlSchema;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlTransient;

/**
 *
 */
@JBossXmlSchema(namespace = "urn:jboss:threads:2.0", elementFormDefault = XmlNsForm.QUALIFIED)
@XmlRootElement(name = "threads")
@XmlType(name = "threads", propOrder = {})
@JBossXmlModelGroup(kind = JBossXmlConstants.MODEL_GROUP_UNORDERED_SEQUENCE)
public final class ThreadsMetaData implements BeanMetaDataFactory {

    private List<ThreadMetaData> threads = new ArrayList<ThreadMetaData>();
    private List<ThreadGroupMetaData> threadGroups = new ArrayList<ThreadGroupMetaData>();
    private List<ThreadFactoryMetaData> threadFactories = new ArrayList<ThreadFactoryMetaData>();
    private List<ThreadFactoryExecutorMetaData> threadFactoryExecutors = new ArrayList<ThreadFactoryExecutorMetaData>();
    private List<UnboundedQueueThreadPoolExecutorMetaData> unboundedQueueThreadPoolExecutors = new ArrayList<UnboundedQueueThreadPoolExecutorMetaData>();
    private List<BoundedQueueThreadPoolExecutorMetaData> boundedQueueThreadPoolExecutors = new ArrayList<BoundedQueueThreadPoolExecutorMetaData>();
    private List<QueuelessThreadPoolExecutorMetaData> queuelessThreadPoolExecutors = new ArrayList<QueuelessThreadPoolExecutorMetaData>();
    private List<ScheduledThreadPoolExecutorMetaData> scheduledThreadPoolExecutors = new ArrayList<ScheduledThreadPoolExecutorMetaData>();
    private List<UnboundedOrderedExecutorMetaData> unboundedOrderedExecutors = new ArrayList<UnboundedOrderedExecutorMetaData>();
    private List<BoundedOrderedExecutorMetaData> boundedOrderedExecutors = new ArrayList<BoundedOrderedExecutorMetaData>();
    private List<DirectExecutorMetaData> directExecutors = new ArrayList<DirectExecutorMetaData>();

    public List<ThreadMetaData> getThreads() {
        return threads;
    }

    @XmlElement(name = "thread")
    public void setThreads(final List<ThreadMetaData> threads) {
        this.threads = threads;
    }

    public List<ThreadGroupMetaData> getThreadGroups() {
        return threadGroups;
    }

    @XmlElement(name = "thread-group")
    public void setThreadGroups(final List<ThreadGroupMetaData> threadGroups) {
        this.threadGroups = threadGroups;
    }

    public List<ThreadFactoryMetaData> getThreadFactories() {
        return threadFactories;
    }

    @XmlElement(name = "thread-factory")
    public void setThreadFactories(final List<ThreadFactoryMetaData> threadFactories) {
        this.threadFactories = threadFactories;
    }

    public List<ThreadFactoryExecutorMetaData> getThreadFactoryExecutors() {
        return threadFactoryExecutors;
    }

    @XmlElement(name = "thread-factory-executor")
    public void setThreadFactoryExecutors(final List<ThreadFactoryExecutorMetaData> threadFactoryExecutors) {
        this.threadFactoryExecutors = threadFactoryExecutors;
    }

    public List<UnboundedQueueThreadPoolExecutorMetaData> getUnboundedQueueThreadPoolExecutors() {
        return unboundedQueueThreadPoolExecutors;
    }

    @XmlElement(name = "unbounded-queue-thread-pool-executor")
    public void setUnboundedQueueThreadPoolExecutors(final List<UnboundedQueueThreadPoolExecutorMetaData> unboundedQueueThreadPoolExecutors) {
        this.unboundedQueueThreadPoolExecutors = unboundedQueueThreadPoolExecutors;
    }

    public List<BoundedQueueThreadPoolExecutorMetaData> getBoundedQueueThreadPoolExecutors() {
        return boundedQueueThreadPoolExecutors;
    }

    @XmlElement(name = "bounded-queue-thread-pool-executor")
    public void setBoundedQueueThreadPoolExecutors(final List<BoundedQueueThreadPoolExecutorMetaData> boundedQueueThreadPoolExecutors) {
        this.boundedQueueThreadPoolExecutors = boundedQueueThreadPoolExecutors;
    }

    public List<QueuelessThreadPoolExecutorMetaData> getQueuelessThreadPoolExecutors() {
        return queuelessThreadPoolExecutors;
    }

    @XmlElement(name = "queueless-thread-pool-executor")
    public void setQueuelessThreadPoolExecutors(final List<QueuelessThreadPoolExecutorMetaData> queuelessThreadPoolExecutors) {
        this.queuelessThreadPoolExecutors = queuelessThreadPoolExecutors;
    }

    public List<ScheduledThreadPoolExecutorMetaData> getScheduledThreadPoolExecutors() {
        return scheduledThreadPoolExecutors;
    }

    @XmlElement(name = "scheduled-thread-pool-executor")
    public void setScheduledThreadPoolExecutors(final List<ScheduledThreadPoolExecutorMetaData> scheduledThreadPoolExecutors) {
        this.scheduledThreadPoolExecutors = scheduledThreadPoolExecutors;
    }

    public List<UnboundedOrderedExecutorMetaData> getUnboundedOrderedExecutors() {
        return unboundedOrderedExecutors;
    }

    @XmlElement(name = "unbounded-ordered-executor")
    public void setUnboundedOrderedExecutors(final List<UnboundedOrderedExecutorMetaData> unboundedOrderedExecutors) {
        this.unboundedOrderedExecutors = unboundedOrderedExecutors;
    }

    public List<BoundedOrderedExecutorMetaData> getBoundedOrderedExecutors() {
        return boundedOrderedExecutors;
    }

    @XmlElement(name = "bounded-ordered-executor")
    public void setBoundedOrderedExecutors(final List<BoundedOrderedExecutorMetaData> boundedOrderedExecutors) {
        this.boundedOrderedExecutors = boundedOrderedExecutors;
    }

    public List<DirectExecutorMetaData> getDirectExecutors() {
        return directExecutors;
    }

    @XmlElement(name = "direct-executor")
    public void setDirectExecutors(final List<DirectExecutorMetaData> directExecutors) {
        this.directExecutors = directExecutors;
    }

    @XmlTransient
    public List<BeanMetaData> getBeans() {
        List<BeanMetaData> beanMetaDataList = new ArrayList<BeanMetaData>();
        for (ThreadMetaData metaData : threads) {
            ThreadsHelper.addMetaData(beanMetaDataList, metaData);
        }
        for (ThreadGroupMetaData metaData : threadGroups) {
            ThreadsHelper.addMetaData(beanMetaDataList, metaData);
        }
        for (ThreadFactoryMetaData metaData : threadFactories) {
            ThreadsHelper.addMetaData(beanMetaDataList, metaData);
        }
        for (ThreadFactoryExecutorMetaData metaData : threadFactoryExecutors) {
            ThreadsHelper.addMetaData(beanMetaDataList, metaData);
        }
        for (UnboundedQueueThreadPoolExecutorMetaData metaData : unboundedQueueThreadPoolExecutors) {
            ThreadsHelper.addMetaData(beanMetaDataList, metaData);
        }
        for (BoundedQueueThreadPoolExecutorMetaData metaData : boundedQueueThreadPoolExecutors) {
            ThreadsHelper.addMetaData(beanMetaDataList, metaData);
        }
        for (QueuelessThreadPoolExecutorMetaData metaData : queuelessThreadPoolExecutors) {
            ThreadsHelper.addMetaData(beanMetaDataList, metaData);
        }
        for (ScheduledThreadPoolExecutorMetaData metaData : scheduledThreadPoolExecutors) {
            ThreadsHelper.addMetaData(beanMetaDataList, metaData);
        }
        for (UnboundedOrderedExecutorMetaData metaData : unboundedOrderedExecutors) {
            ThreadsHelper.addMetaData(beanMetaDataList, metaData);
        }
        for (BoundedOrderedExecutorMetaData metaData : boundedOrderedExecutors) {
            ThreadsHelper.addMetaData(beanMetaDataList, metaData);
        }
        for (DirectExecutorMetaData metaData : directExecutors) {
            ThreadsHelper.addMetaData(beanMetaDataList, metaData);
        }
        return beanMetaDataList;
    }
}
