/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.threads.ArrayQueue;
import org.jboss.threads.BlockingExecutor;
import org.jboss.threads.ExecutionTimedOutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrderedExecutor
implements BlockingExecutor {
    private final Executor parent;
    private final Runnable runner = new Runner();
    private final Lock lock = new ReentrantLock();
    private final Condition removeCondition = this.lock.newCondition();
    private final Queue<Runnable> queue;
    private boolean running;
    private boolean blocking;
    private Executor handoffExecutor;

    public OrderedExecutor(Executor parent) {
        this(parent, new ArrayDeque<Runnable>());
    }

    public OrderedExecutor(Executor parent, Queue<Runnable> queue) {
        this(parent, queue, true, null);
    }

    public OrderedExecutor(Executor parent, int queueLength) {
        this(parent, new ArrayQueue<Runnable>(queueLength), true, null);
    }

    public OrderedExecutor(Executor parent, int queueLength, Executor handoffExecutor) {
        this(parent, new ArrayQueue<Runnable>(queueLength), false, handoffExecutor);
    }

    public OrderedExecutor(Executor parent, Queue<Runnable> queue, boolean blocking, Executor handoffExecutor) {
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        if (queue == null) {
            throw new NullPointerException("queue is null");
        }
        this.queue = queue;
        this.parent = parent;
        this.blocking = blocking;
        this.handoffExecutor = handoffExecutor;
    }

    public OrderedExecutor(Executor parent, int queueLength, boolean blocking, Executor handoffExecutor) {
        this(parent, new ArrayQueue<Runnable>(queueLength), blocking, handoffExecutor);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void execute(Runnable task) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeBlocking(Runnable task) throws RejectedExecutionException, InterruptedException {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        while (true) {
            Object var6_4;
            this.lock.lock();
            try {
                if (!this.running) {
                    Object var4_3;
                    this.running = true;
                    boolean ok = false;
                    try {
                        this.parent.execute(this.runner);
                        ok = true;
                        var4_3 = null;
                        if (!ok) {
                            this.running = false;
                        }
                    }
                    catch (Throwable throwable) {
                        var4_3 = null;
                        if (ok) throw throwable;
                        this.running = false;
                        throw throwable;
                    }
                }
                if (this.queue.offer(task)) {
                    var6_4 = null;
                    this.lock.unlock();
                    return;
                }
                this.removeCondition.await();
                var6_4 = null;
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                var6_4 = null;
                this.lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeBlocking(Runnable task, long timeout, TimeUnit unit) throws RejectedExecutionException, InterruptedException {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        long now = System.currentTimeMillis();
        long deadline = now + unit.toMillis(timeout);
        if (deadline < 0L) {
            this.executeBlocking(task);
            return;
        }
        while (true) {
            Object var13_9;
            this.lock.lock();
            try {
                if (!this.running) {
                    Object var11_8;
                    this.running = true;
                    boolean ok = false;
                    try {
                        this.parent.execute(this.runner);
                        ok = true;
                        var11_8 = null;
                        if (!ok) {
                            this.running = false;
                        }
                    }
                    catch (Throwable throwable) {
                        var11_8 = null;
                        if (ok) throw throwable;
                        this.running = false;
                        throw throwable;
                    }
                }
                if (this.queue.offer(task)) {
                    var13_9 = null;
                    this.lock.unlock();
                    return;
                }
                long remaining = deadline - now;
                if (remaining <= 0L) {
                    throw new ExecutionTimedOutException();
                }
                this.removeCondition.await(remaining, TimeUnit.MILLISECONDS);
                now = System.currentTimeMillis();
                var13_9 = null;
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                var13_9 = null;
                this.lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeNonBlocking(Runnable task) throws RejectedExecutionException {
        Executor executor;
        block10: {
            if (task == null) {
                throw new NullPointerException("task is null");
            }
            this.lock.lock();
            try {
                if (!this.running) {
                    this.running = true;
                    boolean ok = false;
                    try {
                        this.parent.execute(this.runner);
                        ok = true;
                        Object var5_3 = null;
                        if (!ok) {
                            this.running = false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_4 = null;
                        if (!ok) {
                            this.running = false;
                        }
                        throw throwable;
                    }
                }
                if (!this.queue.offer(task)) {
                    executor = this.handoffExecutor;
                    Object var7_7 = null;
                    this.lock.unlock();
                    break block10;
                }
                Object var7_8 = null;
                this.lock.unlock();
                return;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.lock.unlock();
                throw throwable;
            }
        }
        if (executor != null) {
            executor.execute(task);
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object var3_4;
                Runnable task;
                OrderedExecutor.this.lock.lock();
                try {
                    task = (Runnable)OrderedExecutor.this.queue.poll();
                    OrderedExecutor.this.removeCondition.signal();
                    if (task == null) {
                        OrderedExecutor.this.running = false;
                        var3_4 = null;
                        OrderedExecutor.this.lock.unlock();
                        return;
                    }
                    var3_4 = null;
                    OrderedExecutor.this.lock.unlock();
                }
                catch (Throwable throwable) {
                    var3_4 = null;
                    OrderedExecutor.this.lock.unlock();
                    throw throwable;
                }
                try {
                    task.run();
                }
                catch (Throwable throwable) {
                }
            }
        }
    }
}

