/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.lang.reflect.Field;
import java.security.AccessController;
import org.jboss.threads.DeclaredFieldAction;
import org.jboss.threads.DelegatingRunnable;
import org.jboss.threads.JBossExecutors;

final class ThreadLocalResettingRunnable
extends DelegatingRunnable {
    ThreadLocalResettingRunnable(Runnable delegate) {
        super(delegate);
    }

    @Override
    public void run() {
        try {
            super.run();
        }
        finally {
            Resetter.run();
        }
    }

    @Override
    public String toString() {
        return "Thread-local resetting Runnable";
    }

    static final class Resetter {
        private static final long threadLocalMapOffs;
        private static final long inheritableThreadLocalMapOffs;

        Resetter() {
        }

        static void run() {
            Thread thread = Thread.currentThread();
            if (threadLocalMapOffs != 0L) {
                JBossExecutors.unsafe.putObject(thread, threadLocalMapOffs, null);
            }
            if (inheritableThreadLocalMapOffs != 0L) {
                JBossExecutors.unsafe.putObject(thread, inheritableThreadLocalMapOffs, null);
            }
        }

        static {
            Field threadLocals = AccessController.doPrivileged(new DeclaredFieldAction(Thread.class, "threadLocals"));
            threadLocalMapOffs = threadLocals == null ? 0L : JBossExecutors.unsafe.objectFieldOffset(threadLocals);
            Field inheritableThreadLocals = AccessController.doPrivileged(new DeclaredFieldAction(Thread.class, "inheritableThreadLocals"));
            inheritableThreadLocalMapOffs = inheritableThreadLocals == null ? 0L : JBossExecutors.unsafe.objectFieldOffset(inheritableThreadLocals);
        }
    }
}

