/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.tmpdpl.api.container;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.tmpdpl.api.deployable.Deployable;

/**
 * Container
 * 
 * An entity capable of deploying/undeploying {@link Deployable} types
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @version $Revision: $
 */
public interface Container
{
   //-------------------------------------------------------------------------------||
   // Contracts --------------------------------------------------------------------||
   //-------------------------------------------------------------------------------||

   /**
    * Deploys the specified deployables into the server as one atomic operation. 
    * 
    * @param deployables
    * @throws DeploymentException
    * @throws IllegalArgumentException If no deployables were specified or the type of deployable
    * is not supported by this server
    */
   void deploy(Deployable... deployables) throws DeploymentException, IllegalArgumentException;

   /**
    * Deploys the specified archives into the server as one atomic operation. 
    * 
    * @param archives
    * @throws DeploymentException
    * @throws IllegalArgumentException If no archives were specified or the type of archive
    * is not supported by this server
    */
   void deploy(Archive<?>... archives) throws DeploymentException, IllegalArgumentException;

   /**
    * Undeploys the specified deployables from the server as one atomic operation.
    * The deployables must have been previously deployed.
    * 
    * @param deployables
    * @throws DeploymentException
    * @throws IllegalArgumentException If no deployables were specified or the type of deployable
    * is not supported by this server
    */
   void undeploy(Deployable... deployables) throws DeploymentException, IllegalArgumentException;

   /**
    * Undeploys the specified archives from the server as one atomic operation.
    * The archives must have been previously deployed.
    * 
    * @param archives
    * @throws DeploymentException
    * @throws IllegalArgumentException If no archives were specified or the type of archive
    * is not supported by this server
    */
   void undeploy(Archive<?>... archives) throws DeploymentException, IllegalArgumentException;
}
