/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tmpdpl.api.deployable;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static Constructor<?> getConstructor(final Class<?> clazz, final Class<?> ... paramTypes) throws NoSuchMethodException, SecurityException, IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("class must be specified");
        }
        if (paramTypes == null) {
            throw new IllegalArgumentException("param types must be specified");
        }
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>(){

                @Override
                public Constructor<?> run() throws Exception {
                    return clazz.getConstructor(paramTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable unwrapped = pae.getCause();
            if (unwrapped instanceof NoSuchMethodException) {
                NoSuchMethodException nsme = (NoSuchMethodException)unwrapped;
                throw nsme;
            }
            if (unwrapped instanceof SecurityException) {
                SecurityException se = (SecurityException)unwrapped;
                throw se;
            }
            throw new RuntimeException("Error in obtaining constructor", unwrapped);
        }
    }
}

