/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tmpdpl.api.deployable;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.tmpdpl.api.deployable.Deployable;
import org.jboss.tmpdpl.api.deployable.SecurityActions;

public class VfsVdfDeployableFactory {
    private static final Logger log = Logger.getLogger(VfsVdfDeployableFactory.class.getName());
    private static final String CLASS_NAME_VFS_VDF_DEPLOYABLE = "org.jboss.tmpdpl.impl.vdf.VfsVdfDeployableImpl";
    private static final String CLASS_NAME_ARCHIVE_TYPE = "org.jboss.shrinkwrap.api.Archive";
    private static final String METHOD_NAME_CREATE = "create";
    private static Method method;

    private VfsVdfDeployableFactory() {
    }

    public static Deployable createDeployable(Archive<?> archive) throws IllegalArgumentException {
        Deployable deployable;
        Object obj;
        if (archive == null) {
            throw new IllegalArgumentException("Archive must be specified");
        }
        try {
            obj = VfsVdfDeployableFactory.getMethod().invoke(null, archive);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Created: " + obj);
            }
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Could not invoke static method: " + method, iae);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("Could not invoke static method: " + method, ite);
        }
        try {
            deployable = (Deployable)Deployable.class.cast(obj);
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("New instance should be of type " + Deployable.class.getName(), cce);
        }
        return deployable;
    }

    private static synchronized Method getMethod() {
        if (method == null) {
            Class<?> clazz = VfsVdfDeployableFactory.getClass(CLASS_NAME_VFS_VDF_DEPLOYABLE);
            Class<?> paramType = VfsVdfDeployableFactory.getClass(CLASS_NAME_ARCHIVE_TYPE);
            try {
                method = clazz.getDeclaredMethod(METHOD_NAME_CREATE, paramType);
            }
            catch (NoSuchMethodException nsme) {
                throw new RuntimeException("Could not obtain method \"create from " + clazz.getName(), nsme);
            }
        }
        return method;
    }

    private static Class<?> getClass(String className) {
        ClassLoader cl = SecurityActions.getThreadContextClassLoader();
        try {
            return Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not find implementation class \"" + className + "\" in " + cl, cnfe);
        }
    }
}

