/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tmpdpl.impl.vdf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.export.ZipExporter;
import org.jboss.tmpdpl.spi.vdf.VdfDeployable;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

public class VfsVdfDeployableImpl
implements VdfDeployable {
    private static final Logger log = Logger.getLogger(VfsVdfDeployableImpl.class.getName());
    private static final String SYS_PROP_TMP_DIR = "java.io.tmpdir";
    private Deployment deployment;
    private SoftReference<Archive<?>> createdFromArchive;

    private VfsVdfDeployableImpl(Deployment deployment) throws IllegalArgumentException {
        assert (deployment != null) : "Deployment must be specified";
        this.setDeployment(deployment);
    }

    public static VdfDeployable create(Archive<?> archive) throws IllegalArgumentException {
        if (archive == null) {
            throw new IllegalArgumentException("archive must be specified");
        }
        InputStream zipStream = ZipExporter.exportZip(archive);
        String name = archive.getName();
        VfsVdfDeployableImpl deployable = (VfsVdfDeployableImpl)VfsVdfDeployableImpl.create(name, zipStream);
        deployable.setCreatedFromArchive(new SoftReference(archive));
        return deployable;
    }

    public static VdfDeployable create(String name, InputStream archive) throws IllegalArgumentException {
        FileOutputStream out;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name must be specified");
        }
        if (archive == null) {
            throw new IllegalArgumentException("archive must be specified");
        }
        String tempDirLocation = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(VfsVdfDeployableImpl.SYS_PROP_TMP_DIR);
            }
        });
        File tmpDir = new File(tempDirLocation);
        if (!tmpDir.exists()) {
            throw new IllegalStateException("Could not obtain valid temp directory: " + tmpDir.getAbsolutePath());
        }
        if (!tmpDir.isDirectory()) {
            throw new IllegalStateException("Temp location must be a directory: " + tmpDir.getAbsolutePath());
        }
        File tmpFile = new File(tmpDir, name);
        tmpFile.deleteOnExit();
        try {
            out = new FileOutputStream(tmpFile);
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException("Created temp file could not be found: " + tmpFile);
        }
        int len = 1024;
        byte[] buffer = new byte[1024];
        int read = 0;
        try {
            while ((read = archive.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error in obtainting bytes from " + archive, ioe);
        }
        finally {
            try {
                archive.close();
            }
            catch (IOException ignore) {}
            try {
                ((OutputStream)out).close();
            }
            catch (IOException ignore) {}
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using temporary file to back deployable: " + tmpFile.getAbsolutePath());
        }
        return VfsVdfDeployableImpl.create(tmpFile);
    }

    public static VdfDeployable create(File archive) throws IllegalArgumentException {
        VirtualFile file;
        if (archive == null) {
            throw new IllegalArgumentException("archive must be specified");
        }
        if (!archive.exists()) {
            throw new IllegalArgumentException("archive must exist: " + archive.getAbsolutePath());
        }
        URI uri = archive.toURI();
        try {
            file = VFS.createNewRoot((URI)uri);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create new VFS root from " + archive, e);
        }
        VFSDeployment deployment = VFSDeploymentFactory.getInstance().createVFSDeployment(file);
        log.fine("Created deployment: " + deployment);
        VfsVdfDeployableImpl deployable = new VfsVdfDeployableImpl((Deployment)deployment);
        return deployable;
    }

    public static VdfDeployable create(URL archive) throws IllegalArgumentException {
        InputStream in;
        if (archive == null) {
            throw new IllegalArgumentException("archive must be specified");
        }
        try {
            in = archive.openConnection().getInputStream();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not get stream from archive: " + archive, ioe);
        }
        String name = archive.getPath();
        return VfsVdfDeployableImpl.create(name, in);
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.createdFromArchive != null) {
            return 31 * result + this.createdFromArchive.get().hashCode();
        }
        result = 31 * result + (this.deployment == null ? 0 : this.deployment.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VfsVdfDeployableImpl other = (VfsVdfDeployableImpl)obj;
        if (this.createdFromArchive != null) {
            SoftReference<Archive<?>> otherCreatedFromArchive = other.getCreatedFromArchive();
            if (otherCreatedFromArchive == null) {
                return false;
            }
            if (this.createdFromArchive.get().equals(otherCreatedFromArchive.get())) {
                return true;
            }
        }
        return !(this.deployment == null ? other.deployment != null : !this.deployment.equals(other.deployment));
    }

    private void setDeployment(Deployment deployment) {
        this.deployment = deployment;
    }

    private SoftReference<Archive<?>> getCreatedFromArchive() {
        return this.createdFromArchive;
    }

    private void setCreatedFromArchive(SoftReference<Archive<?>> createdFromArchive) {
        this.createdFromArchive = createdFromArchive;
    }
}

