/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.std.NullSerializer;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import org.jsonschema2pojo.exception.GenerationException;

public class SchemaGenerator {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);

    public ObjectNode schemaFromExample(URL example) {
        try {
            JsonNode content = OBJECT_MAPPER.readTree(example);
            return this.schemaFromExample(content);
        }
        catch (IOException e) {
            throw new GenerationException("Could not process JSON in source file", e);
        }
    }

    public ObjectNode schemaFromExample(JsonNode example) {
        if (example.isObject()) {
            return this.objectSchema(example);
        }
        if (example.isArray()) {
            return this.arraySchema(example);
        }
        return this.simpleTypeSchema(example);
    }

    private ObjectNode objectSchema(JsonNode exampleObject) {
        ObjectNode schema = OBJECT_MAPPER.createObjectNode();
        schema.put("type", "object");
        ObjectNode properties = OBJECT_MAPPER.createObjectNode();
        Iterator iter = exampleObject.fieldNames();
        while (iter.hasNext()) {
            String property = (String)iter.next();
            properties.put(property, (JsonNode)this.schemaFromExample(exampleObject.get(property)));
        }
        schema.put("properties", (JsonNode)properties);
        return schema;
    }

    private ObjectNode arraySchema(JsonNode exampleArray) {
        ObjectNode schema = OBJECT_MAPPER.createObjectNode();
        schema.put("type", "array");
        if (exampleArray.size() > 0) {
            JsonNode exampleItem = exampleArray.get(0).isObject() ? this.mergeArrayItems(exampleArray) : exampleArray.get(0);
            schema.put("items", (JsonNode)this.schemaFromExample(exampleItem));
        }
        return schema;
    }

    private JsonNode mergeArrayItems(JsonNode exampleArray) {
        ObjectNode mergedItems = OBJECT_MAPPER.createObjectNode();
        for (JsonNode item : exampleArray) {
            if (!item.isObject()) continue;
            mergedItems.putAll((ObjectNode)item);
        }
        return mergedItems;
    }

    private ObjectNode simpleTypeSchema(JsonNode exampleValue) {
        try {
            Object valueAsJavaType = OBJECT_MAPPER.treeToValue((TreeNode)exampleValue, Object.class);
            SchemaAware valueSerializer = this.getValueSerializer(valueAsJavaType);
            return (ObjectNode)valueSerializer.getSchema(OBJECT_MAPPER.getSerializerProvider(), null);
        }
        catch (JsonMappingException e) {
            throw new GenerationException("Unable to generate a schema for this json example: " + exampleValue, e);
        }
        catch (JsonProcessingException e) {
            throw new GenerationException("Unable to generate a schema for this json example: " + exampleValue, e);
        }
    }

    private SchemaAware getValueSerializer(Object valueAsJavaType) throws JsonMappingException {
        DefaultSerializerProvider.Impl serializerProvider = new DefaultSerializerProvider.Impl().createInstance(OBJECT_MAPPER.getSerializationConfig(), (SerializerFactory)BeanSerializerFactory.instance);
        if (valueAsJavaType == null) {
            return NullSerializer.instance;
        }
        if (valueAsJavaType instanceof Long) {
            JsonSerializer valueSerializer = serializerProvider.findValueSerializer(Integer.class, null);
            return (SchemaAware)valueSerializer;
        }
        Class<?> javaTypeForValue = valueAsJavaType.getClass();
        JsonSerializer valueSerializer = serializerProvider.findValueSerializer(javaTypeForValue, null);
        return (SchemaAware)valueSerializer;
    }
}

