/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.PrimitiveTypes;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;

public class TypeRule
implements Rule<JClassContainer, JType> {
    private static final String DEFAULT_TYPE_NAME = "any";
    private final RuleFactory ruleFactory;

    protected TypeRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JType apply(String nodeName, JsonNode node, JClassContainer jClassContainer, Schema schema) {
        String propertyTypeName = this.getTypeName(node);
        Object type = propertyTypeName.equals("object") || node.has("properties") && node.path("properties").size() > 0 ? this.ruleFactory.getObjectRule().apply(nodeName, node, jClassContainer.getPackage(), schema) : (node.has("javaType") ? this.getJavaType(node.path("javaType").asText(), jClassContainer.owner()) : (propertyTypeName.equals("string") ? jClassContainer.owner().ref(String.class) : (propertyTypeName.equals("number") ? this.getNumberType(jClassContainer.owner(), node, this.ruleFactory.getGenerationConfig()) : (propertyTypeName.equals("integer") ? this.getIntegerType(jClassContainer.owner(), node, this.ruleFactory.getGenerationConfig()) : (propertyTypeName.equals("boolean") ? this.unboxIfNecessary((JType)jClassContainer.owner().ref(Boolean.class), this.ruleFactory.getGenerationConfig()) : (propertyTypeName.equals("array") ? (JType)this.ruleFactory.getArrayRule().apply(nodeName, node, jClassContainer.getPackage(), schema) : jClassContainer.owner().ref(Object.class)))))));
        if (!node.has("javaType") && node.has("format")) {
            type = this.ruleFactory.getFormatRule().apply(nodeName, node.get("format"), (JType)type, schema);
        } else if (!node.has("javaType") && propertyTypeName.equals("string") && node.has("media")) {
            type = this.ruleFactory.getMediaRule().apply(nodeName, node.get("media"), (JType)type, schema);
        }
        return type;
    }

    private String getTypeName(JsonNode node) {
        if (node.has("type") && node.get("type").isArray() && node.get("type").size() > 0) {
            return node.get("type").get(0).asText();
        }
        if (node.has("type")) {
            return node.get("type").asText();
        }
        return DEFAULT_TYPE_NAME;
    }

    private JType unboxIfNecessary(JType type, GenerationConfig config) {
        if (config.isUsePrimitives()) {
            return type.unboxify();
        }
        return type;
    }

    private JType getIntegerType(JCodeModel owner, JsonNode node, GenerationConfig config) {
        if (config.isUseLongIntegers()) {
            return this.unboxIfNecessary((JType)owner.ref(Long.class), config);
        }
        return this.unboxIfNecessary((JType)owner.ref(Integer.class), config);
    }

    private JType getNumberType(JCodeModel owner, JsonNode node, GenerationConfig config) {
        if (config.isUseDoubleNumbers()) {
            return this.unboxIfNecessary((JType)owner.ref(Double.class), config);
        }
        return this.unboxIfNecessary((JType)owner.ref(Float.class), config);
    }

    private JType getJavaType(String javaTypeName, JCodeModel owner) {
        if (PrimitiveTypes.isPrimitive(javaTypeName, owner)) {
            return PrimitiveTypes.primitiveType(javaTypeName, owner);
        }
        return owner.ref(javaTypeName);
    }
}

