/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTree;

final class DescendantEnumeration
extends AxisIteratorImpl {
    private TinyTree tree;
    private TinyNodeImpl startNode;
    private boolean includeSelf;
    private int nextNodeNr;
    private int startDepth;
    private NodeTest test;

    DescendantEnumeration(TinyTree doc, TinyNodeImpl node, NodeTest nodeTest, boolean includeSelf) {
        this.tree = doc;
        this.startNode = node;
        this.includeSelf = includeSelf;
        this.test = nodeTest;
        this.nextNodeNr = node.nodeNr;
        this.startDepth = doc.depth[this.nextNodeNr];
    }

    @Override
    public Item next() {
        if (this.position == 0 && this.includeSelf && this.test.matches(this.startNode)) {
            this.current = this.startNode;
            ++this.position;
            return this.current;
        }
        do {
            ++this.nextNodeNr;
            try {
                if (this.tree.depth[this.nextNodeNr] > this.startDepth) continue;
                this.nextNodeNr = -1;
                this.current = null;
                this.position = -1;
                return null;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.nextNodeNr = -1;
                this.current = null;
                this.position = -1;
                return null;
            }
        } while (!this.test.matches(this.tree, this.nextNodeNr));
        ++this.position;
        this.current = this.tree.getNode(this.nextNodeNr);
        return this.current;
    }

    @Override
    public SequenceIterator getAnother() {
        return new DescendantEnumeration(this.tree, this.startNode, this.test, this.includeSelf);
    }
}

