/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQExpression;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQStaticContext;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xqj.Closable;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQDataFactory;
import net.sf.saxon.xqj.SaxonXQDynamicContext;
import net.sf.saxon.xqj.SaxonXQPreparedExpression;
import net.sf.saxon.xqj.SaxonXQStaticContext;

public class SaxonXQExpression
extends SaxonXQDynamicContext
implements XQExpression {
    SaxonXQStaticContext sqc;
    DynamicQueryContext context;
    boolean closed;

    SaxonXQExpression(SaxonXQConnection connection) throws XQException {
        this.connection = connection;
        this.context = new DynamicQueryContext(connection.getConfiguration());
        this.sqc = (SaxonXQStaticContext)connection.getStaticContext();
        this.setClosableContainer(connection);
    }

    SaxonXQExpression(SaxonXQConnection connection, SaxonXQStaticContext staticContext) {
        this.connection = connection;
        this.context = new DynamicQueryContext(connection.getConfiguration());
        this.sqc = staticContext;
        this.setClosableContainer(connection);
    }

    @Override
    protected DynamicQueryContext getDynamicContext() {
        return this.context;
    }

    @Override
    protected SaxonXQDataFactory getDataFactory() throws XQException {
        return this.connection;
    }

    @Override
    public void cancel() throws XQException {
        this.checkNotClosed();
    }

    @Override
    public void executeCommand(Reader command) throws XQException {
        this.checkNotClosed();
        throw new XQException("Saxon does not recognize any non-XQuery commands");
    }

    @Override
    public void executeCommand(String command) throws XQException {
        this.checkNotClosed();
        throw new XQException("Saxon does not recognize any non-XQuery commands");
    }

    @Override
    public XQResultSequence executeQuery(InputStream query) throws XQException {
        this.checkNotClosed();
        try {
            StaticQueryContext env = this.sqc.getSaxonStaticQueryContext();
            XQueryExpression exp = env.compileQuery(query, null);
            SaxonXQPreparedExpression pe = new SaxonXQPreparedExpression(this.connection, exp, this.sqc, this.context);
            return pe.executeQuery();
        }
        catch (XPathException e) {
            XQException xqe = new XQException(e.getMessage());
            xqe.initCause(e);
            throw xqe;
        }
        catch (IOException e) {
            XQException xqe = new XQException(e.getMessage());
            xqe.initCause(e);
            throw xqe;
        }
    }

    @Override
    public XQResultSequence executeQuery(Reader query) throws XQException {
        this.checkNotClosed();
        try {
            StaticQueryContext env = this.sqc.getSaxonStaticQueryContext();
            XQueryExpression exp = env.compileQuery(query);
            SaxonXQPreparedExpression pe = new SaxonXQPreparedExpression(this.connection, exp, this.sqc, this.context);
            return pe.executeQuery();
        }
        catch (XPathException e) {
            XQException xqe = new XQException(e.getMessage());
            xqe.initCause(e);
            throw xqe;
        }
        catch (IOException e) {
            XQException xqe = new XQException(e.getMessage());
            xqe.initCause(e);
            throw xqe;
        }
    }

    @Override
    public XQResultSequence executeQuery(String query) throws XQException {
        this.checkNotClosed();
        try {
            StaticQueryContext env = this.sqc.getSaxonStaticQueryContext();
            XQueryExpression exp = env.compileQuery(query);
            SaxonXQPreparedExpression pe = new SaxonXQPreparedExpression(this.connection, exp, this.sqc, this.context);
            XQResultSequence result = pe.executeQuery();
            ((Closable)((Object)result)).setClosableContainer(this);
            return result;
        }
        catch (XPathException e) {
            XQException xqe = new XQException(e.getMessage());
            xqe.initCause(e);
            throw xqe;
        }
    }

    @Override
    public XQStaticContext getStaticContext() throws XQException {
        this.checkNotClosed();
        return this.connection.getStaticContext();
    }

    @Override
    protected boolean externalVariableExists(QName name) {
        return true;
    }
}

