/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.DoubleArrays;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractDoubleArrayAssert<S extends AbstractDoubleArrayAssert<S>>
extends AbstractArrayAssert<S, double[], Double> {
    @VisibleForTesting
    protected DoubleArrays arrays = DoubleArrays.instance();

    public AbstractDoubleArrayAssert(double[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (double[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (double[])this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (double[])this.actual);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (double[])this.actual, expected);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (double[])this.actual, other);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    public S contains(double ... values) {
        this.arrays.assertContains(this.info, (double[])this.actual, values);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    public S containsOnly(double ... values) {
        this.arrays.assertContainsOnly(this.info, (double[])this.actual, values);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    public S containsOnlyOnce(double ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (double[])this.actual, values);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    public S containsSequence(double ... sequence) {
        this.arrays.assertContainsSequence(this.info, (double[])this.actual, sequence);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    public S containsSubsequence(double ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (double[])this.actual, subsequence);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    public S contains(double value, Index index) {
        this.arrays.assertContains(this.info, (double[])this.actual, value, index);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    public S doesNotContain(double ... values) {
        this.arrays.assertDoesNotContain(this.info, (double[])this.actual, values);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    public S doesNotContain(double value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (double[])this.actual, value, index);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    public S doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (double[])this.actual);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    public S startsWith(double ... sequence) {
        this.arrays.assertStartsWith(this.info, (double[])this.actual, sequence);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    public S endsWith(double ... sequence) {
        this.arrays.assertEndsWith(this.info, (double[])this.actual, sequence);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public S isSorted() {
        this.arrays.assertIsSorted(this.info, (double[])this.actual);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public S isSortedAccordingTo(Comparator<? super Double> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (double[])this.actual, comparator);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super Double> customComparator) {
        this.arrays = new DoubleArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        this.arrays = DoubleArrays.instance();
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }

    public S containsExactly(double ... values) {
        this.arrays.assertContainsExactly(this.info, (double[])this.actual, values);
        return (S)((AbstractDoubleArrayAssert)this.myself);
    }
}

